@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetIpGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands resourceIds (of Firewalls/Network Security Groups etc.) back referenced by the IpGroups resource.
 * @property ipGroupsName The name of the ipGroups.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetIpGroupPlainArgs(
    public val expand: String? = null,
    public val ipGroupsName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetIpGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetIpGroupPlainArgs =
        com.pulumi.azurenative.network.inputs.GetIpGroupPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .ipGroupsName(ipGroupsName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIpGroupPlainArgs].
 */
@PulumiTagMarker
public class GetIpGroupPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var ipGroupsName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Expands resourceIds (of Firewalls/Network Security Groups etc.) back referenced by the IpGroups resource.
     */
    @JvmName("wbcplwqhnhgeuaop")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the ipGroups.
     */
    @JvmName("mrmfowoddwcavupm")
    public suspend fun ipGroupsName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ipGroupsName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ucntxoxybdeqaujw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIpGroupPlainArgs = GetIpGroupPlainArgs(
        expand = expand,
        ipGroupsName = ipGroupsName ?: throw PulumiNullFieldException("ipGroupsName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
