@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetNetworkManagerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkManagerName The name of the network manager.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetNetworkManagerPlainArgs(
    public val networkManagerName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetNetworkManagerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetNetworkManagerPlainArgs =
        com.pulumi.azurenative.network.inputs.GetNetworkManagerPlainArgs.builder()
            .networkManagerName(networkManagerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkManagerPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkManagerPlainArgsBuilder internal constructor() {
    private var networkManagerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the network manager.
     */
    @JvmName("uewmqgpiwvgwpxhv")
    public suspend fun networkManagerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkManagerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ufotqqbloonkiwhh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkManagerPlainArgs = GetNetworkManagerPlainArgs(
        networkManagerName = networkManagerName ?: throw PulumiNullFieldException("networkManagerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
