@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetNspAssociationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property associationName The name of the NSP association.
 * @property networkSecurityPerimeterName The name of the network security perimeter.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetNspAssociationPlainArgs(
    public val associationName: String,
    public val networkSecurityPerimeterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetNspAssociationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetNspAssociationPlainArgs =
        com.pulumi.azurenative.network.inputs.GetNspAssociationPlainArgs.builder()
            .associationName(associationName.let({ args0 -> args0 }))
            .networkSecurityPerimeterName(networkSecurityPerimeterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNspAssociationPlainArgs].
 */
@PulumiTagMarker
public class GetNspAssociationPlainArgsBuilder internal constructor() {
    private var associationName: String? = null

    private var networkSecurityPerimeterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the NSP association.
     */
    @JvmName("noufgvvxeeqyuyfc")
    public suspend fun associationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.associationName = mapped
    }

    /**
     * @param value The name of the network security perimeter.
     */
    @JvmName("tfaerjulwblyuhco")
    public suspend fun networkSecurityPerimeterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkSecurityPerimeterName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jgsdbrypemibwjpn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNspAssociationPlainArgs = GetNspAssociationPlainArgs(
        associationName = associationName ?: throw PulumiNullFieldException("associationName"),
        networkSecurityPerimeterName = networkSecurityPerimeterName ?: throw
            PulumiNullFieldException("networkSecurityPerimeterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
