@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetNspLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property linkName The name of the NSP link.
 * @property networkSecurityPerimeterName The name of the network security perimeter.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetNspLinkPlainArgs(
    public val linkName: String,
    public val networkSecurityPerimeterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetNspLinkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetNspLinkPlainArgs =
        com.pulumi.azurenative.network.inputs.GetNspLinkPlainArgs.builder()
            .linkName(linkName.let({ args0 -> args0 }))
            .networkSecurityPerimeterName(networkSecurityPerimeterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNspLinkPlainArgs].
 */
@PulumiTagMarker
public class GetNspLinkPlainArgsBuilder internal constructor() {
    private var linkName: String? = null

    private var networkSecurityPerimeterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the NSP link.
     */
    @JvmName("tjhusydotbvguato")
    public suspend fun linkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.linkName = mapped
    }

    /**
     * @param value The name of the network security perimeter.
     */
    @JvmName("hkwpmwdlbussiemn")
    public suspend fun networkSecurityPerimeterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkSecurityPerimeterName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pakbkrienkuqffwa")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNspLinkPlainArgs = GetNspLinkPlainArgs(
        linkName = linkName ?: throw PulumiNullFieldException("linkName"),
        networkSecurityPerimeterName = networkSecurityPerimeterName ?: throw
            PulumiNullFieldException("networkSecurityPerimeterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
