@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property policyName The name of the Web Application Firewall Policy.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetPolicyPlainArgs(
    public val policyName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetPolicyPlainArgs =
        com.pulumi.azurenative.network.inputs.GetPolicyPlainArgs.builder()
            .policyName(policyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetPolicyPlainArgsBuilder internal constructor() {
    private var policyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Web Application Firewall Policy.
     */
    @JvmName("wxmddtehfcmtntlr")
    public suspend fun policyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("qvjhjaakrnmhhqod")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPolicyPlainArgs = GetPolicyPlainArgs(
        policyName = policyName ?: throw PulumiNullFieldException("policyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
