@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetRouteMapPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The resource group name of the RouteMap's resource group.
 * @property routeMapName The name of the RouteMap.
 * @property virtualHubName The name of the VirtualHub containing the RouteMap.
 */
public data class GetRouteMapPlainArgs(
    public val resourceGroupName: String,
    public val routeMapName: String,
    public val virtualHubName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetRouteMapPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetRouteMapPlainArgs =
        com.pulumi.azurenative.network.inputs.GetRouteMapPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .routeMapName(routeMapName.let({ args0 -> args0 }))
            .virtualHubName(virtualHubName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRouteMapPlainArgs].
 */
@PulumiTagMarker
public class GetRouteMapPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var routeMapName: String? = null

    private var virtualHubName: String? = null

    /**
     * @param value The resource group name of the RouteMap's resource group.
     */
    @JvmName("qmxvwfcrffdxyegx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the RouteMap.
     */
    @JvmName("jenybhtmrueykkjc")
    public suspend fun routeMapName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.routeMapName = mapped
    }

    /**
     * @param value The name of the VirtualHub containing the RouteMap.
     */
    @JvmName("igavmnvgokqaoofw")
    public suspend fun virtualHubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualHubName = mapped
    }

    internal fun build(): GetRouteMapPlainArgs = GetRouteMapPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        routeMapName = routeMapName ?: throw PulumiNullFieldException("routeMapName"),
        virtualHubName = virtualHubName ?: throw PulumiNullFieldException("virtualHubName"),
    )
}
