@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetServiceEndpointPolicyDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition name.
 * @property serviceEndpointPolicyName The name of the service endpoint policy name.
 */
public data class GetServiceEndpointPolicyDefinitionPlainArgs(
    public val resourceGroupName: String,
    public val serviceEndpointPolicyDefinitionName: String,
    public val serviceEndpointPolicyName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetServiceEndpointPolicyDefinitionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetServiceEndpointPolicyDefinitionPlainArgs =
        com.pulumi.azurenative.network.inputs.GetServiceEndpointPolicyDefinitionPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceEndpointPolicyDefinitionName(serviceEndpointPolicyDefinitionName.let({ args0 -> args0 }))
            .serviceEndpointPolicyName(serviceEndpointPolicyName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServiceEndpointPolicyDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetServiceEndpointPolicyDefinitionPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serviceEndpointPolicyDefinitionName: String? = null

    private var serviceEndpointPolicyName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("luabgrllarvhewaa")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service endpoint policy definition name.
     */
    @JvmName("qrfguuplhnpwvcvs")
    public suspend fun serviceEndpointPolicyDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceEndpointPolicyDefinitionName = mapped
    }

    /**
     * @param value The name of the service endpoint policy name.
     */
    @JvmName("ciwwbwixtberiibk")
    public suspend fun serviceEndpointPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceEndpointPolicyName = mapped
    }

    internal fun build(): GetServiceEndpointPolicyDefinitionPlainArgs =
        GetServiceEndpointPolicyDefinitionPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            serviceEndpointPolicyDefinitionName = serviceEndpointPolicyDefinitionName ?: throw
                PulumiNullFieldException("serviceEndpointPolicyDefinitionName"),
            serviceEndpointPolicyName = serviceEndpointPolicyName ?: throw
                PulumiNullFieldException("serviceEndpointPolicyName"),
        )
}
