@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetSubscriptionNetworkManagerConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkManagerConnectionName Name for the network manager connection.
 */
public data class GetSubscriptionNetworkManagerConnectionPlainArgs(
    public val networkManagerConnectionName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetSubscriptionNetworkManagerConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetSubscriptionNetworkManagerConnectionPlainArgs =
        com.pulumi.azurenative.network.inputs.GetSubscriptionNetworkManagerConnectionPlainArgs.builder()
            .networkManagerConnectionName(networkManagerConnectionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSubscriptionNetworkManagerConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetSubscriptionNetworkManagerConnectionPlainArgsBuilder internal constructor() {
    private var networkManagerConnectionName: String? = null

    /**
     * @param value Name for the network manager connection.
     */
    @JvmName("lgmkjlinwrronvft")
    public suspend fun networkManagerConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkManagerConnectionName = mapped
    }

    internal fun build(): GetSubscriptionNetworkManagerConnectionPlainArgs =
        GetSubscriptionNetworkManagerConnectionPlainArgs(
            networkManagerConnectionName = networkManagerConnectionName ?: throw
                PulumiNullFieldException("networkManagerConnectionName"),
        )
}
