@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayAdvertisedRoutesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property peer The IP address of the peer.
 * @property resourceGroupName The name of the resource group.
 * @property virtualNetworkGatewayName The name of the virtual network gateway.
 */
public data class GetVirtualNetworkGatewayAdvertisedRoutesPlainArgs(
    public val peer: String,
    public val resourceGroupName: String,
    public val virtualNetworkGatewayName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayAdvertisedRoutesPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayAdvertisedRoutesPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayAdvertisedRoutesPlainArgs.builder()
            .peer(peer.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualNetworkGatewayName(virtualNetworkGatewayName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualNetworkGatewayAdvertisedRoutesPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNetworkGatewayAdvertisedRoutesPlainArgsBuilder internal constructor() {
    private var peer: String? = null

    private var resourceGroupName: String? = null

    private var virtualNetworkGatewayName: String? = null

    /**
     * @param value The IP address of the peer.
     */
    @JvmName("tqrawyowhoujflmr")
    public suspend fun peer(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peer = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wihrbdsihmrqiblp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual network gateway.
     */
    @JvmName("pjbyiifloqugwtlo")
    public suspend fun virtualNetworkGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkGatewayName = mapped
    }

    internal fun build(): GetVirtualNetworkGatewayAdvertisedRoutesPlainArgs =
        GetVirtualNetworkGatewayAdvertisedRoutesPlainArgs(
            peer = peer ?: throw PulumiNullFieldException("peer"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            virtualNetworkGatewayName = virtualNetworkGatewayName ?: throw
                PulumiNullFieldException("virtualNetworkGatewayName"),
        )
}
