@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayVpnclientConnectionHealthPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property virtualNetworkGatewayName The name of the virtual network gateway.
 */
public data class GetVirtualNetworkGatewayVpnclientConnectionHealthPlainArgs(
    public val resourceGroupName: String,
    public val virtualNetworkGatewayName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayVpnclientConnectionHealthPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayVpnclientConnectionHealthPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayVpnclientConnectionHealthPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualNetworkGatewayName(virtualNetworkGatewayName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualNetworkGatewayVpnclientConnectionHealthPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNetworkGatewayVpnclientConnectionHealthPlainArgsBuilder internal
constructor() {
    private var resourceGroupName: String? = null

    private var virtualNetworkGatewayName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vofrugwddugjvgkh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual network gateway.
     */
    @JvmName("bxjwvhundpylxemv")
    public suspend fun virtualNetworkGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkGatewayName = mapped
    }

    internal fun build(): GetVirtualNetworkGatewayVpnclientConnectionHealthPlainArgs =
        GetVirtualNetworkGatewayVpnclientConnectionHealthPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            virtualNetworkGatewayName = virtualNetworkGatewayName ?: throw
                PulumiNullFieldException("virtualNetworkGatewayName"),
        )
}
