@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualNetworkPeeringPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property virtualNetworkName The name of the virtual network.
 * @property virtualNetworkPeeringName The name of the virtual network peering.
 */
public data class GetVirtualNetworkPeeringPlainArgs(
    public val resourceGroupName: String,
    public val virtualNetworkName: String,
    public val virtualNetworkPeeringName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualNetworkPeeringPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVirtualNetworkPeeringPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualNetworkPeeringPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualNetworkName(virtualNetworkName.let({ args0 -> args0 }))
            .virtualNetworkPeeringName(virtualNetworkPeeringName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualNetworkPeeringPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNetworkPeeringPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var virtualNetworkName: String? = null

    private var virtualNetworkPeeringName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("eogdvebnamrdkryb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual network.
     */
    @JvmName("daygncgukjekyhui")
    public suspend fun virtualNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkName = mapped
    }

    /**
     * @param value The name of the virtual network peering.
     */
    @JvmName("obysbdabbfwhwvln")
    public suspend fun virtualNetworkPeeringName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkPeeringName = mapped
    }

    internal fun build(): GetVirtualNetworkPeeringPlainArgs = GetVirtualNetworkPeeringPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualNetworkName = virtualNetworkName ?: throw PulumiNullFieldException("virtualNetworkName"),
        virtualNetworkPeeringName = virtualNetworkPeeringName ?: throw
            PulumiNullFieldException("virtualNetworkPeeringName"),
    )
}
