@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualRouterPeeringPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property peeringName The name of the Virtual Router Peering.
 * @property resourceGroupName The name of the resource group.
 * @property virtualRouterName The name of the Virtual Router.
 */
public data class GetVirtualRouterPeeringPlainArgs(
    public val peeringName: String,
    public val resourceGroupName: String,
    public val virtualRouterName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualRouterPeeringPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVirtualRouterPeeringPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualRouterPeeringPlainArgs.builder()
            .peeringName(peeringName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualRouterName(virtualRouterName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualRouterPeeringPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualRouterPeeringPlainArgsBuilder internal constructor() {
    private var peeringName: String? = null

    private var resourceGroupName: String? = null

    private var virtualRouterName: String? = null

    /**
     * @param value The name of the Virtual Router Peering.
     */
    @JvmName("rcxucotxdudybhge")
    public suspend fun peeringName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peeringName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pdyxwftmbktvrnxe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Virtual Router.
     */
    @JvmName("rciiymxeekjbkalm")
    public suspend fun virtualRouterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualRouterName = mapped
    }

    internal fun build(): GetVirtualRouterPeeringPlainArgs = GetVirtualRouterPeeringPlainArgs(
        peeringName = peeringName ?: throw PulumiNullFieldException("peeringName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualRouterName = virtualRouterName ?: throw PulumiNullFieldException("virtualRouterName"),
    )
}
