@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVpnLinkConnectionIkeSasPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName The name of the vpn connection.
 * @property gatewayName The name of the gateway.
 * @property linkConnectionName The name of the vpn link connection.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetVpnLinkConnectionIkeSasPlainArgs(
    public val connectionName: String,
    public val gatewayName: String,
    public val linkConnectionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVpnLinkConnectionIkeSasPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVpnLinkConnectionIkeSasPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVpnLinkConnectionIkeSasPlainArgs.builder()
            .connectionName(connectionName.let({ args0 -> args0 }))
            .gatewayName(gatewayName.let({ args0 -> args0 }))
            .linkConnectionName(linkConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpnLinkConnectionIkeSasPlainArgs].
 */
@PulumiTagMarker
public class GetVpnLinkConnectionIkeSasPlainArgsBuilder internal constructor() {
    private var connectionName: String? = null

    private var gatewayName: String? = null

    private var linkConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the vpn connection.
     */
    @JvmName("vqbhgvfytvvbqili")
    public suspend fun connectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionName = mapped
    }

    /**
     * @param value The name of the gateway.
     */
    @JvmName("jhvrixemsjtlvlks")
    public suspend fun gatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gatewayName = mapped
    }

    /**
     * @param value The name of the vpn link connection.
     */
    @JvmName("xgqrvhamfhmlvvur")
    public suspend fun linkConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.linkConnectionName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qqoovcsvjkimtxni")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetVpnLinkConnectionIkeSasPlainArgs = GetVpnLinkConnectionIkeSasPlainArgs(
        connectionName = connectionName ?: throw PulumiNullFieldException("connectionName"),
        gatewayName = gatewayName ?: throw PulumiNullFieldException("gatewayName"),
        linkConnectionName = linkConnectionName ?: throw PulumiNullFieldException("linkConnectionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
