@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetWebApplicationFirewallPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property policyName The name of the policy.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetWebApplicationFirewallPolicyPlainArgs(
    public val policyName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetWebApplicationFirewallPolicyPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetWebApplicationFirewallPolicyPlainArgs =
        com.pulumi.azurenative.network.inputs.GetWebApplicationFirewallPolicyPlainArgs.builder()
            .policyName(policyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebApplicationFirewallPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetWebApplicationFirewallPolicyPlainArgsBuilder internal constructor() {
    private var policyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the policy.
     */
    @JvmName("ewewtfyaulfqymcy")
    public suspend fun policyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ppgfvpimrfnlceaj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWebApplicationFirewallPolicyPlainArgs =
        GetWebApplicationFirewallPolicyPlainArgs(
            policyName = policyName ?: throw PulumiNullFieldException("policyName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
