@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetZonePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property zoneName The name of the DNS zone (without a terminating dot).
 */
public data class GetZonePlainArgs(
    public val resourceGroupName: String,
    public val zoneName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetZonePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetZonePlainArgs =
        com.pulumi.azurenative.network.inputs.GetZonePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .zoneName(zoneName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetZonePlainArgs].
 */
@PulumiTagMarker
public class GetZonePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var zoneName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("fglcexdflobjbvmy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the DNS zone (without a terminating dot).
     */
    @JvmName("onjfojoanrmvewro")
    public suspend fun zoneName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.zoneName = mapped
    }

    internal fun build(): GetZonePlainArgs = GetZonePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        zoneName = zoneName ?: throw PulumiNullFieldException("zoneName"),
    )
}
