@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.IPConfigurationBgpPeeringAddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of IPConfigurationBgpPeeringAddress.
 * @property customBgpIpAddresses The list of custom BGP peering addresses which belong to IP configuration.
 * @property ipconfigurationId The ID of IP configuration which belongs to gateway.
 */
public data class IPConfigurationBgpPeeringAddressArgs(
    public val customBgpIpAddresses: Output<List<String>>? = null,
    public val ipconfigurationId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.IPConfigurationBgpPeeringAddressArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.IPConfigurationBgpPeeringAddressArgs =
        com.pulumi.azurenative.network.inputs.IPConfigurationBgpPeeringAddressArgs.builder()
            .customBgpIpAddresses(customBgpIpAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipconfigurationId(ipconfigurationId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IPConfigurationBgpPeeringAddressArgs].
 */
@PulumiTagMarker
public class IPConfigurationBgpPeeringAddressArgsBuilder internal constructor() {
    private var customBgpIpAddresses: Output<List<String>>? = null

    private var ipconfigurationId: Output<String>? = null

    /**
     * @param value The list of custom BGP peering addresses which belong to IP configuration.
     */
    @JvmName("sovvfsytykwevxwx")
    public suspend fun customBgpIpAddresses(`value`: Output<List<String>>) {
        this.customBgpIpAddresses = value
    }

    @JvmName("ftinewsvnfumftcw")
    public suspend fun customBgpIpAddresses(vararg values: Output<String>) {
        this.customBgpIpAddresses = Output.all(values.asList())
    }

    /**
     * @param values The list of custom BGP peering addresses which belong to IP configuration.
     */
    @JvmName("gynajbrsvwyfbxew")
    public suspend fun customBgpIpAddresses(values: List<Output<String>>) {
        this.customBgpIpAddresses = Output.all(values)
    }

    /**
     * @param value The ID of IP configuration which belongs to gateway.
     */
    @JvmName("mlxmavfjwrxcvymi")
    public suspend fun ipconfigurationId(`value`: Output<String>) {
        this.ipconfigurationId = value
    }

    /**
     * @param value The list of custom BGP peering addresses which belong to IP configuration.
     */
    @JvmName("dhoxwmojqmgxnsem")
    public suspend fun customBgpIpAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customBgpIpAddresses = mapped
    }

    /**
     * @param values The list of custom BGP peering addresses which belong to IP configuration.
     */
    @JvmName("bmrgxdabxwmbafgf")
    public suspend fun customBgpIpAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customBgpIpAddresses = mapped
    }

    /**
     * @param value The ID of IP configuration which belongs to gateway.
     */
    @JvmName("euobhtcmmtcvdyyx")
    public suspend fun ipconfigurationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipconfigurationId = mapped
    }

    internal fun build(): IPConfigurationBgpPeeringAddressArgs = IPConfigurationBgpPeeringAddressArgs(
        customBgpIpAddresses = customBgpIpAddresses,
        ipconfigurationId = ipconfigurationId,
    )
}
