@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.IpTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains the IpTag associated with the object.
 * @property ipTagType The IP tag type. Example: FirstPartyUsage.
 * @property tag The value of the IP tag associated with the public IP. Example: SQL.
 */
public data class IpTagArgs(
    public val ipTagType: Output<String>? = null,
    public val tag: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.IpTagArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.IpTagArgs =
        com.pulumi.azurenative.network.inputs.IpTagArgs.builder()
            .ipTagType(ipTagType?.applyValue({ args0 -> args0 }))
            .tag(tag?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpTagArgs].
 */
@PulumiTagMarker
public class IpTagArgsBuilder internal constructor() {
    private var ipTagType: Output<String>? = null

    private var tag: Output<String>? = null

    /**
     * @param value The IP tag type. Example: FirstPartyUsage.
     */
    @JvmName("ljoajdmojnltluji")
    public suspend fun ipTagType(`value`: Output<String>) {
        this.ipTagType = value
    }

    /**
     * @param value The value of the IP tag associated with the public IP. Example: SQL.
     */
    @JvmName("iqgrjncxtqsvclbh")
    public suspend fun tag(`value`: Output<String>) {
        this.tag = value
    }

    /**
     * @param value The IP tag type. Example: FirstPartyUsage.
     */
    @JvmName("xtocmgxqexqeikeb")
    public suspend fun ipTagType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipTagType = mapped
    }

    /**
     * @param value The value of the IP tag associated with the public IP. Example: SQL.
     */
    @JvmName("qdxaxdwibgabqjot")
    public suspend fun tag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    internal fun build(): IpTagArgs = IpTagArgs(
        ipTagType = ipTagType,
        tag = tag,
    )
}
