@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ListDnsForwardingRulesetByVirtualNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property top The maximum number of results to return. If not specified, returns up to 100 results.
 * @property virtualNetworkName The name of the virtual network.
 */
public data class ListDnsForwardingRulesetByVirtualNetworkPlainArgs(
    public val resourceGroupName: String,
    public val top: Int? = null,
    public val virtualNetworkName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ListDnsForwardingRulesetByVirtualNetworkPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ListDnsForwardingRulesetByVirtualNetworkPlainArgs =
        com.pulumi.azurenative.network.inputs.ListDnsForwardingRulesetByVirtualNetworkPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 }))
            .virtualNetworkName(virtualNetworkName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListDnsForwardingRulesetByVirtualNetworkPlainArgs].
 */
@PulumiTagMarker
public class ListDnsForwardingRulesetByVirtualNetworkPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var top: Int? = null

    private var virtualNetworkName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mofehksxfnvvmgkl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The maximum number of results to return. If not specified, returns up to 100 results.
     */
    @JvmName("rvvdoydndjlippvi")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    /**
     * @param value The name of the virtual network.
     */
    @JvmName("uindmniaoxqsdgeb")
    public suspend fun virtualNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkName = mapped
    }

    internal fun build(): ListDnsForwardingRulesetByVirtualNetworkPlainArgs =
        ListDnsForwardingRulesetByVirtualNetworkPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            top = top,
            virtualNetworkName = virtualNetworkName ?: throw PulumiNullFieldException("virtualNetworkName"),
        )
}
