@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ListDnsResolverByVirtualNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property top The maximum number of results to return. If not specified, returns up to 100 results.
 * @property virtualNetworkName The name of the virtual network.
 */
public data class ListDnsResolverByVirtualNetworkPlainArgs(
    public val resourceGroupName: String,
    public val top: Int? = null,
    public val virtualNetworkName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ListDnsResolverByVirtualNetworkPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ListDnsResolverByVirtualNetworkPlainArgs =
        com.pulumi.azurenative.network.inputs.ListDnsResolverByVirtualNetworkPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 }))
            .virtualNetworkName(virtualNetworkName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListDnsResolverByVirtualNetworkPlainArgs].
 */
@PulumiTagMarker
public class ListDnsResolverByVirtualNetworkPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var top: Int? = null

    private var virtualNetworkName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ecqbxsidfbxybikc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The maximum number of results to return. If not specified, returns up to 100 results.
     */
    @JvmName("bmowpeqhjyuixqqn")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    /**
     * @param value The name of the virtual network.
     */
    @JvmName("dwsjpavnbhkyumhp")
    public suspend fun virtualNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkName = mapped
    }

    internal fun build(): ListDnsResolverByVirtualNetworkPlainArgs =
        ListDnsResolverByVirtualNetworkPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            top = top,
            virtualNetworkName = virtualNetworkName ?: throw PulumiNullFieldException("virtualNetworkName"),
        )
}
