@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ListEffectiveConnectivityConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property skipToken When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
 * @property virtualNetworkName The name of the virtual network.
 */
public data class ListEffectiveConnectivityConfigurationPlainArgs(
    public val resourceGroupName: String,
    public val skipToken: String? = null,
    public val virtualNetworkName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ListEffectiveConnectivityConfigurationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ListEffectiveConnectivityConfigurationPlainArgs =
        com.pulumi.azurenative.network.inputs.ListEffectiveConnectivityConfigurationPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .skipToken(skipToken?.let({ args0 -> args0 }))
            .virtualNetworkName(virtualNetworkName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListEffectiveConnectivityConfigurationPlainArgs].
 */
@PulumiTagMarker
public class ListEffectiveConnectivityConfigurationPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var skipToken: String? = null

    private var virtualNetworkName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("msbqtojemmlmpjyc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
     */
    @JvmName("vjyqextoajxueltr")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    /**
     * @param value The name of the virtual network.
     */
    @JvmName("tnhxhtxwyubmsqvv")
    public suspend fun virtualNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkName = mapped
    }

    internal fun build(): ListEffectiveConnectivityConfigurationPlainArgs =
        ListEffectiveConnectivityConfigurationPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            skipToken = skipToken,
            virtualNetworkName = virtualNetworkName ?: throw PulumiNullFieldException("virtualNetworkName"),
        )
}
