@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ListEffectiveVirtualNetworkByNetworkManagerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property conditionalMembers Conditional Members.
 * @property networkManagerName The name of the network manager.
 * @property resourceGroupName The name of the resource group.
 * @property skipToken Continuation token for pagination, capturing the next page size and offset, as well as the context of the query.
 * @property top An optional query parameter which specifies the maximum number of records to be returned by the server.
 */
public data class ListEffectiveVirtualNetworkByNetworkManagerPlainArgs(
    public val conditionalMembers: String? = null,
    public val networkManagerName: String,
    public val resourceGroupName: String,
    public val skipToken: String? = null,
    public val top: Int? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ListEffectiveVirtualNetworkByNetworkManagerPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ListEffectiveVirtualNetworkByNetworkManagerPlainArgs =
        com.pulumi.azurenative.network.inputs.ListEffectiveVirtualNetworkByNetworkManagerPlainArgs.builder()
            .conditionalMembers(conditionalMembers?.let({ args0 -> args0 }))
            .networkManagerName(networkManagerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .skipToken(skipToken?.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListEffectiveVirtualNetworkByNetworkManagerPlainArgs].
 */
@PulumiTagMarker
public class ListEffectiveVirtualNetworkByNetworkManagerPlainArgsBuilder internal constructor() {
    private var conditionalMembers: String? = null

    private var networkManagerName: String? = null

    private var resourceGroupName: String? = null

    private var skipToken: String? = null

    private var top: Int? = null

    /**
     * @param value Conditional Members.
     */
    @JvmName("qmhgxifgglixbssm")
    public suspend fun conditionalMembers(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.conditionalMembers = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("dojwtvvwdyohcehr")
    public suspend fun networkManagerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkManagerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hdsglrdlnreqqfoh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Continuation token for pagination, capturing the next page size and offset, as well as the context of the query.
     */
    @JvmName("bifbqbluqeupwpgo")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    /**
     * @param value An optional query parameter which specifies the maximum number of records to be returned by the server.
     */
    @JvmName("cjybctwdyaqkkyvt")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    internal fun build(): ListEffectiveVirtualNetworkByNetworkManagerPlainArgs =
        ListEffectiveVirtualNetworkByNetworkManagerPlainArgs(
            conditionalMembers = conditionalMembers,
            networkManagerName = networkManagerName ?: throw PulumiNullFieldException("networkManagerName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            skipToken = skipToken,
            top = top,
        )
}
