@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ListFirewallPolicyIdpsSignaturesFilterValuePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property filterName Describes the name of the column which values will be returned
 * @property firewallPolicyName The name of the Firewall Policy.
 * @property resourceGroupName The name of the resource group.
 */
public data class ListFirewallPolicyIdpsSignaturesFilterValuePlainArgs(
    public val filterName: String? = null,
    public val firewallPolicyName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ListFirewallPolicyIdpsSignaturesFilterValuePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ListFirewallPolicyIdpsSignaturesFilterValuePlainArgs =
        com.pulumi.azurenative.network.inputs.ListFirewallPolicyIdpsSignaturesFilterValuePlainArgs.builder()
            .filterName(filterName?.let({ args0 -> args0 }))
            .firewallPolicyName(firewallPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListFirewallPolicyIdpsSignaturesFilterValuePlainArgs].
 */
@PulumiTagMarker
public class ListFirewallPolicyIdpsSignaturesFilterValuePlainArgsBuilder internal constructor() {
    private var filterName: String? = null

    private var firewallPolicyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Describes the name of the column which values will be returned
     */
    @JvmName("fljbdhbctnpcwqcd")
    public suspend fun filterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filterName = mapped
    }

    /**
     * @param value The name of the Firewall Policy.
     */
    @JvmName("ynhanjbeuxjgucrb")
    public suspend fun firewallPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.firewallPolicyName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jvsscdmiqgfkjtml")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListFirewallPolicyIdpsSignaturesFilterValuePlainArgs =
        ListFirewallPolicyIdpsSignaturesFilterValuePlainArgs(
            filterName = filterName,
            firewallPolicyName = firewallPolicyName ?: throw PulumiNullFieldException("firewallPolicyName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
