@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.LoadDistribution
import com.pulumi.azurenative.network.kotlin.enums.TransportProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A load balancing rule for a load balancer.
 * @property backendAddressPool A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
 * @property backendAddressPools An array of references to pool of DIPs.
 * @property backendPort The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables "Any Port".
 * @property disableOutboundSnat Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing rule.
 * @property enableFloatingIP Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
 * @property enableTcpReset Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
 * @property frontendIPConfiguration A reference to frontend IP addresses.
 * @property frontendPort The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0 enables "Any Port".
 * @property id Resource ID.
 * @property idleTimeoutInMinutes The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
 * @property loadDistribution The load distribution policy for this rule.
 * @property name The name of the resource that is unique within the set of load balancing rules used by the load balancer. This name can be used to access the resource.
 * @property probe The reference to the load balancer probe used by the load balancing rule.
 * @property protocol The reference to the transport protocol used by the load balancing rule.
 */
public data class LoadBalancingRuleArgs(
    public val backendAddressPool: Output<SubResourceArgs>? = null,
    public val backendAddressPools: Output<List<SubResourceArgs>>? = null,
    public val backendPort: Output<Int>? = null,
    public val disableOutboundSnat: Output<Boolean>? = null,
    public val enableFloatingIP: Output<Boolean>? = null,
    public val enableTcpReset: Output<Boolean>? = null,
    public val frontendIPConfiguration: Output<SubResourceArgs>? = null,
    public val frontendPort: Output<Int>,
    public val id: Output<String>? = null,
    public val idleTimeoutInMinutes: Output<Int>? = null,
    public val loadDistribution: Output<Either<String, LoadDistribution>>? = null,
    public val name: Output<String>? = null,
    public val probe: Output<SubResourceArgs>? = null,
    public val protocol: Output<Either<String, TransportProtocol>>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs =
        com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs.builder()
            .backendAddressPool(
                backendAddressPool?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .backendAddressPools(
                backendAddressPools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .backendPort(backendPort?.applyValue({ args0 -> args0 }))
            .disableOutboundSnat(disableOutboundSnat?.applyValue({ args0 -> args0 }))
            .enableFloatingIP(enableFloatingIP?.applyValue({ args0 -> args0 }))
            .enableTcpReset(enableTcpReset?.applyValue({ args0 -> args0 }))
            .frontendIPConfiguration(
                frontendIPConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .frontendPort(frontendPort.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .idleTimeoutInMinutes(idleTimeoutInMinutes?.applyValue({ args0 -> args0 }))
            .loadDistribution(
                loadDistribution?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .probe(probe?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protocol(
                protocol.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [LoadBalancingRuleArgs].
 */
@PulumiTagMarker
public class LoadBalancingRuleArgsBuilder internal constructor() {
    private var backendAddressPool: Output<SubResourceArgs>? = null

    private var backendAddressPools: Output<List<SubResourceArgs>>? = null

    private var backendPort: Output<Int>? = null

    private var disableOutboundSnat: Output<Boolean>? = null

    private var enableFloatingIP: Output<Boolean>? = null

    private var enableTcpReset: Output<Boolean>? = null

    private var frontendIPConfiguration: Output<SubResourceArgs>? = null

    private var frontendPort: Output<Int>? = null

    private var id: Output<String>? = null

    private var idleTimeoutInMinutes: Output<Int>? = null

    private var loadDistribution: Output<Either<String, LoadDistribution>>? = null

    private var name: Output<String>? = null

    private var probe: Output<SubResourceArgs>? = null

    private var protocol: Output<Either<String, TransportProtocol>>? = null

    /**
     * @param value A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
     */
    @JvmName("xrqkimbtenaoqwhe")
    public suspend fun backendAddressPool(`value`: Output<SubResourceArgs>) {
        this.backendAddressPool = value
    }

    /**
     * @param value An array of references to pool of DIPs.
     */
    @JvmName("cckicpkedwotqxff")
    public suspend fun backendAddressPools(`value`: Output<List<SubResourceArgs>>) {
        this.backendAddressPools = value
    }

    @JvmName("scgpewjrpvllqhwa")
    public suspend fun backendAddressPools(vararg values: Output<SubResourceArgs>) {
        this.backendAddressPools = Output.all(values.asList())
    }

    /**
     * @param values An array of references to pool of DIPs.
     */
    @JvmName("fbssrmlpqggcbmld")
    public suspend fun backendAddressPools(values: List<Output<SubResourceArgs>>) {
        this.backendAddressPools = Output.all(values)
    }

    /**
     * @param value The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables "Any Port".
     */
    @JvmName("mdevvtagjcivwabl")
    public suspend fun backendPort(`value`: Output<Int>) {
        this.backendPort = value
    }

    /**
     * @param value Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing rule.
     */
    @JvmName("qapkjvnhktsjfvpf")
    public suspend fun disableOutboundSnat(`value`: Output<Boolean>) {
        this.disableOutboundSnat = value
    }

    /**
     * @param value Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
     */
    @JvmName("ketqdodskmdsvxpr")
    public suspend fun enableFloatingIP(`value`: Output<Boolean>) {
        this.enableFloatingIP = value
    }

    /**
     * @param value Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
     */
    @JvmName("dpmmoskyapctlkat")
    public suspend fun enableTcpReset(`value`: Output<Boolean>) {
        this.enableTcpReset = value
    }

    /**
     * @param value A reference to frontend IP addresses.
     */
    @JvmName("qtmvdwxivocdcudl")
    public suspend fun frontendIPConfiguration(`value`: Output<SubResourceArgs>) {
        this.frontendIPConfiguration = value
    }

    /**
     * @param value The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0 enables "Any Port".
     */
    @JvmName("cxkjsrjcvwnoisha")
    public suspend fun frontendPort(`value`: Output<Int>) {
        this.frontendPort = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("riysspypylshbbte")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
     */
    @JvmName("dagokeyxtrbdmvhr")
    public suspend fun idleTimeoutInMinutes(`value`: Output<Int>) {
        this.idleTimeoutInMinutes = value
    }

    /**
     * @param value The load distribution policy for this rule.
     */
    @JvmName("cvtutlvuidobexmd")
    public suspend fun loadDistribution(`value`: Output<Either<String, LoadDistribution>>) {
        this.loadDistribution = value
    }

    /**
     * @param value The name of the resource that is unique within the set of load balancing rules used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("bvnvelywjhsbqajy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The reference to the load balancer probe used by the load balancing rule.
     */
    @JvmName("ovpmvbwabolkyvcy")
    public suspend fun probe(`value`: Output<SubResourceArgs>) {
        this.probe = value
    }

    /**
     * @param value The reference to the transport protocol used by the load balancing rule.
     */
    @JvmName("fludbkgsnxabncdq")
    public suspend fun protocol(`value`: Output<Either<String, TransportProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
     */
    @JvmName("moumlbvkfwjueupw")
    public suspend fun backendAddressPool(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendAddressPool = mapped
    }

    /**
     * @param argument A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
     */
    @JvmName("wuebtyinfxukvshv")
    public suspend fun backendAddressPool(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendAddressPool = mapped
    }

    /**
     * @param value An array of references to pool of DIPs.
     */
    @JvmName("kcqlobpasfhatqhp")
    public suspend fun backendAddressPools(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendAddressPools = mapped
    }

    /**
     * @param argument An array of references to pool of DIPs.
     */
    @JvmName("ltlelvhmtqjdcxft")
    public suspend
    fun backendAddressPools(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.backendAddressPools = mapped
    }

    /**
     * @param argument An array of references to pool of DIPs.
     */
    @JvmName("lolujekqwwavswhi")
    public suspend fun backendAddressPools(
        vararg
        argument: suspend SubResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.backendAddressPools = mapped
    }

    /**
     * @param argument An array of references to pool of DIPs.
     */
    @JvmName("gnjihqjgnreorrxw")
    public suspend fun backendAddressPools(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.backendAddressPools = mapped
    }

    /**
     * @param values An array of references to pool of DIPs.
     */
    @JvmName("ticdrobdhpyjvkkf")
    public suspend fun backendAddressPools(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendAddressPools = mapped
    }

    /**
     * @param value The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables "Any Port".
     */
    @JvmName("phvsqjdmgacvclcx")
    public suspend fun backendPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendPort = mapped
    }

    /**
     * @param value Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing rule.
     */
    @JvmName("tulwetnrypqcnapc")
    public suspend fun disableOutboundSnat(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableOutboundSnat = mapped
    }

    /**
     * @param value Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
     */
    @JvmName("vjndymoamjgbapxc")
    public suspend fun enableFloatingIP(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableFloatingIP = mapped
    }

    /**
     * @param value Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
     */
    @JvmName("hgcfsoivhsmaginx")
    public suspend fun enableTcpReset(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableTcpReset = mapped
    }

    /**
     * @param value A reference to frontend IP addresses.
     */
    @JvmName("icimwtccgttoabup")
    public suspend fun frontendIPConfiguration(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendIPConfiguration = mapped
    }

    /**
     * @param argument A reference to frontend IP addresses.
     */
    @JvmName("ofujnopibmijocqi")
    public suspend fun frontendIPConfiguration(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.frontendIPConfiguration = mapped
    }

    /**
     * @param value The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0 enables "Any Port".
     */
    @JvmName("itliksjssxjhcddg")
    public suspend fun frontendPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendPort = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ijbglwnlwaxpeodm")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
     */
    @JvmName("sylgrjpgybhgpkdy")
    public suspend fun idleTimeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeoutInMinutes = mapped
    }

    /**
     * @param value The load distribution policy for this rule.
     */
    @JvmName("wdegyykmussfdydm")
    public suspend fun loadDistribution(`value`: Either<String, LoadDistribution>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadDistribution = mapped
    }

    /**
     * @param value The load distribution policy for this rule.
     */
    @JvmName("foqxdfsxkeouabqj")
    public fun loadDistribution(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LoadDistribution>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadDistribution = mapped
    }

    /**
     * @param value The load distribution policy for this rule.
     */
    @JvmName("pouquyidyprycgib")
    public fun loadDistribution(`value`: LoadDistribution) {
        val toBeMapped = Either.ofRight<String, LoadDistribution>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadDistribution = mapped
    }

    /**
     * @param value The name of the resource that is unique within the set of load balancing rules used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("jgrcuaixrhdbkjgp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The reference to the load balancer probe used by the load balancing rule.
     */
    @JvmName("hhgauufcnhkhibvp")
    public suspend fun probe(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probe = mapped
    }

    /**
     * @param argument The reference to the load balancer probe used by the load balancing rule.
     */
    @JvmName("himqgntrmunksqgt")
    public suspend fun probe(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.probe = mapped
    }

    /**
     * @param value The reference to the transport protocol used by the load balancing rule.
     */
    @JvmName("wnskisfnrmsiittb")
    public suspend fun protocol(`value`: Either<String, TransportProtocol>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The reference to the transport protocol used by the load balancing rule.
     */
    @JvmName("jlwfsusgknchnwin")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TransportProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The reference to the transport protocol used by the load balancing rule.
     */
    @JvmName("aguqwykikgdbubnw")
    public fun protocol(`value`: TransportProtocol) {
        val toBeMapped = Either.ofRight<String, TransportProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): LoadBalancingRuleArgs = LoadBalancingRuleArgs(
        backendAddressPool = backendAddressPool,
        backendAddressPools = backendAddressPools,
        backendPort = backendPort,
        disableOutboundSnat = disableOutboundSnat,
        enableFloatingIP = enableFloatingIP,
        enableTcpReset = enableTcpReset,
        frontendIPConfiguration = frontendIPConfiguration,
        frontendPort = frontendPort ?: throw PulumiNullFieldException("frontendPort"),
        id = id,
        idleTimeoutInMinutes = idleTimeoutInMinutes,
        loadDistribution = loadDistribution,
        name = name,
        probe = probe,
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
    )
}
