@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ManagedRuleSetListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the list of managed rule sets for the policy.
 * @property managedRuleSets List of rule sets.
 */
public data class ManagedRuleSetListArgs(
    public val managedRuleSets: Output<List<FrontDoorManagedRuleSetArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ManagedRuleSetListArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ManagedRuleSetListArgs =
        com.pulumi.azurenative.network.inputs.ManagedRuleSetListArgs.builder()
            .managedRuleSets(
                managedRuleSets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedRuleSetListArgs].
 */
@PulumiTagMarker
public class ManagedRuleSetListArgsBuilder internal constructor() {
    private var managedRuleSets: Output<List<FrontDoorManagedRuleSetArgs>>? = null

    /**
     * @param value List of rule sets.
     */
    @JvmName("takusjabuytbtrlg")
    public suspend fun managedRuleSets(`value`: Output<List<FrontDoorManagedRuleSetArgs>>) {
        this.managedRuleSets = value
    }

    @JvmName("gsrymynvleyjggkg")
    public suspend fun managedRuleSets(vararg values: Output<FrontDoorManagedRuleSetArgs>) {
        this.managedRuleSets = Output.all(values.asList())
    }

    /**
     * @param values List of rule sets.
     */
    @JvmName("vuvnfbtgpjpoliar")
    public suspend fun managedRuleSets(values: List<Output<FrontDoorManagedRuleSetArgs>>) {
        this.managedRuleSets = Output.all(values)
    }

    /**
     * @param value List of rule sets.
     */
    @JvmName("ihtibpnoujwyhbxg")
    public suspend fun managedRuleSets(`value`: List<FrontDoorManagedRuleSetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedRuleSets = mapped
    }

    /**
     * @param argument List of rule sets.
     */
    @JvmName("owrqoptsrkyubtcf")
    public suspend
    fun managedRuleSets(argument: List<suspend FrontDoorManagedRuleSetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrontDoorManagedRuleSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedRuleSets = mapped
    }

    /**
     * @param argument List of rule sets.
     */
    @JvmName("oxoubmmrsuodotux")
    public suspend fun managedRuleSets(
        vararg
        argument: suspend FrontDoorManagedRuleSetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FrontDoorManagedRuleSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedRuleSets = mapped
    }

    /**
     * @param argument List of rule sets.
     */
    @JvmName("htfvgweuftyhujay")
    public suspend
    fun managedRuleSets(argument: suspend FrontDoorManagedRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FrontDoorManagedRuleSetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.managedRuleSets = mapped
    }

    /**
     * @param values List of rule sets.
     */
    @JvmName("amiqrwcgsjsirxej")
    public suspend fun managedRuleSets(vararg values: FrontDoorManagedRuleSetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedRuleSets = mapped
    }

    internal fun build(): ManagedRuleSetListArgs = ManagedRuleSetListArgs(
        managedRuleSets = managedRuleSets,
    )
}
