@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.MonitorConfigArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.MonitorProtocol
import com.pulumi.azurenative.network.kotlin.enums.ProfileMonitorStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Class containing endpoint monitoring settings in a Traffic Manager profile.
 * @property customHeaders List of custom headers.
 * @property expectedStatusCodeRanges List of expected status code ranges.
 * @property intervalInSeconds The monitor interval for endpoints in this profile. This is the interval at which Traffic Manager will check the health of each endpoint in this profile.
 * @property path The path relative to the endpoint domain name used to probe for endpoint health.
 * @property port The TCP port used to probe for endpoint health.
 * @property profileMonitorStatus The profile-level monitoring status of the Traffic Manager profile.
 * @property protocol The protocol (HTTP, HTTPS or TCP) used to probe for endpoint health.
 * @property timeoutInSeconds The monitor timeout for endpoints in this profile. This is the time that Traffic Manager allows endpoints in this profile to response to the health check.
 * @property toleratedNumberOfFailures The number of consecutive failed health check that Traffic Manager tolerates before declaring an endpoint in this profile Degraded after the next failed health check.
 */
public data class MonitorConfigArgs(
    public val customHeaders: Output<List<MonitorConfigCustomHeadersArgs>>? = null,
    public val expectedStatusCodeRanges: Output<List<MonitorConfigExpectedStatusCodeRangesArgs>>? =
        null,
    public val intervalInSeconds: Output<Double>? = null,
    public val path: Output<String>? = null,
    public val port: Output<Double>? = null,
    public val profileMonitorStatus: Output<Either<String, ProfileMonitorStatus>>? = null,
    public val protocol: Output<Either<String, MonitorProtocol>>? = null,
    public val timeoutInSeconds: Output<Double>? = null,
    public val toleratedNumberOfFailures: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.MonitorConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.MonitorConfigArgs =
        com.pulumi.azurenative.network.inputs.MonitorConfigArgs.builder()
            .customHeaders(
                customHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .expectedStatusCodeRanges(
                expectedStatusCodeRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .intervalInSeconds(intervalInSeconds?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .profileMonitorStatus(
                profileMonitorStatus?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .timeoutInSeconds(timeoutInSeconds?.applyValue({ args0 -> args0 }))
            .toleratedNumberOfFailures(toleratedNumberOfFailures?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonitorConfigArgs].
 */
@PulumiTagMarker
public class MonitorConfigArgsBuilder internal constructor() {
    private var customHeaders: Output<List<MonitorConfigCustomHeadersArgs>>? = null

    private var expectedStatusCodeRanges: Output<List<MonitorConfigExpectedStatusCodeRangesArgs>>? =
        null

    private var intervalInSeconds: Output<Double>? = null

    private var path: Output<String>? = null

    private var port: Output<Double>? = null

    private var profileMonitorStatus: Output<Either<String, ProfileMonitorStatus>>? = null

    private var protocol: Output<Either<String, MonitorProtocol>>? = null

    private var timeoutInSeconds: Output<Double>? = null

    private var toleratedNumberOfFailures: Output<Double>? = null

    /**
     * @param value List of custom headers.
     */
    @JvmName("cioryqbnqwgfnqvl")
    public suspend fun customHeaders(`value`: Output<List<MonitorConfigCustomHeadersArgs>>) {
        this.customHeaders = value
    }

    @JvmName("rvbjccmwilbhdymx")
    public suspend fun customHeaders(vararg values: Output<MonitorConfigCustomHeadersArgs>) {
        this.customHeaders = Output.all(values.asList())
    }

    /**
     * @param values List of custom headers.
     */
    @JvmName("xgfjardtcipjkijs")
    public suspend fun customHeaders(values: List<Output<MonitorConfigCustomHeadersArgs>>) {
        this.customHeaders = Output.all(values)
    }

    /**
     * @param value List of expected status code ranges.
     */
    @JvmName("wwayvlurorqcdvhx")
    public suspend
    fun expectedStatusCodeRanges(`value`: Output<List<MonitorConfigExpectedStatusCodeRangesArgs>>) {
        this.expectedStatusCodeRanges = value
    }

    @JvmName("rndkrgdxrrgblwee")
    public suspend fun expectedStatusCodeRanges(
        vararg
        values: Output<MonitorConfigExpectedStatusCodeRangesArgs>,
    ) {
        this.expectedStatusCodeRanges = Output.all(values.asList())
    }

    /**
     * @param values List of expected status code ranges.
     */
    @JvmName("irbfuiiqogwyjbek")
    public suspend
    fun expectedStatusCodeRanges(values: List<Output<MonitorConfigExpectedStatusCodeRangesArgs>>) {
        this.expectedStatusCodeRanges = Output.all(values)
    }

    /**
     * @param value The monitor interval for endpoints in this profile. This is the interval at which Traffic Manager will check the health of each endpoint in this profile.
     */
    @JvmName("kquxhragtsofvgcn")
    public suspend fun intervalInSeconds(`value`: Output<Double>) {
        this.intervalInSeconds = value
    }

    /**
     * @param value The path relative to the endpoint domain name used to probe for endpoint health.
     */
    @JvmName("crxgirdhjlmcimhi")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The TCP port used to probe for endpoint health.
     */
    @JvmName("vkwkgcbfhypmrsvm")
    public suspend fun port(`value`: Output<Double>) {
        this.port = value
    }

    /**
     * @param value The profile-level monitoring status of the Traffic Manager profile.
     */
    @JvmName("eywgnitjoedhibbc")
    public suspend fun profileMonitorStatus(`value`: Output<Either<String, ProfileMonitorStatus>>) {
        this.profileMonitorStatus = value
    }

    /**
     * @param value The protocol (HTTP, HTTPS or TCP) used to probe for endpoint health.
     */
    @JvmName("nxacgtylercjewef")
    public suspend fun protocol(`value`: Output<Either<String, MonitorProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The monitor timeout for endpoints in this profile. This is the time that Traffic Manager allows endpoints in this profile to response to the health check.
     */
    @JvmName("gqgdjprvrayhggrh")
    public suspend fun timeoutInSeconds(`value`: Output<Double>) {
        this.timeoutInSeconds = value
    }

    /**
     * @param value The number of consecutive failed health check that Traffic Manager tolerates before declaring an endpoint in this profile Degraded after the next failed health check.
     */
    @JvmName("xhymyetsffpsdnkp")
    public suspend fun toleratedNumberOfFailures(`value`: Output<Double>) {
        this.toleratedNumberOfFailures = value
    }

    /**
     * @param value List of custom headers.
     */
    @JvmName("nfuqevfrajwknniw")
    public suspend fun customHeaders(`value`: List<MonitorConfigCustomHeadersArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHeaders = mapped
    }

    /**
     * @param argument List of custom headers.
     */
    @JvmName("fekvqmaqdpalalks")
    public suspend
    fun customHeaders(argument: List<suspend MonitorConfigCustomHeadersArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MonitorConfigCustomHeadersArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customHeaders = mapped
    }

    /**
     * @param argument List of custom headers.
     */
    @JvmName("ippvjjwanjvllduk")
    public suspend fun customHeaders(
        vararg
        argument: suspend MonitorConfigCustomHeadersArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MonitorConfigCustomHeadersArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customHeaders = mapped
    }

    /**
     * @param argument List of custom headers.
     */
    @JvmName("khdlnejnvigfrfos")
    public suspend
    fun customHeaders(argument: suspend MonitorConfigCustomHeadersArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MonitorConfigCustomHeadersArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customHeaders = mapped
    }

    /**
     * @param values List of custom headers.
     */
    @JvmName("rygbwbnrvsdlckoa")
    public suspend fun customHeaders(vararg values: MonitorConfigCustomHeadersArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customHeaders = mapped
    }

    /**
     * @param value List of expected status code ranges.
     */
    @JvmName("ugqcpnqhrsrogdml")
    public suspend
    fun expectedStatusCodeRanges(`value`: List<MonitorConfigExpectedStatusCodeRangesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedStatusCodeRanges = mapped
    }

    /**
     * @param argument List of expected status code ranges.
     */
    @JvmName("yqbubnafoviljbwr")
    public suspend
    fun expectedStatusCodeRanges(argument: List<suspend MonitorConfigExpectedStatusCodeRangesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MonitorConfigExpectedStatusCodeRangesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.expectedStatusCodeRanges = mapped
    }

    /**
     * @param argument List of expected status code ranges.
     */
    @JvmName("ogkryihwaqxkrruk")
    public suspend fun expectedStatusCodeRanges(
        vararg
        argument: suspend MonitorConfigExpectedStatusCodeRangesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MonitorConfigExpectedStatusCodeRangesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.expectedStatusCodeRanges = mapped
    }

    /**
     * @param argument List of expected status code ranges.
     */
    @JvmName("ayfqajdoijfdwfjq")
    public suspend
    fun expectedStatusCodeRanges(argument: suspend MonitorConfigExpectedStatusCodeRangesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MonitorConfigExpectedStatusCodeRangesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.expectedStatusCodeRanges = mapped
    }

    /**
     * @param values List of expected status code ranges.
     */
    @JvmName("bmmtjnvsmrhogrii")
    public suspend fun expectedStatusCodeRanges(
        vararg
        values: MonitorConfigExpectedStatusCodeRangesArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expectedStatusCodeRanges = mapped
    }

    /**
     * @param value The monitor interval for endpoints in this profile. This is the interval at which Traffic Manager will check the health of each endpoint in this profile.
     */
    @JvmName("wbwwvjwttkebsdua")
    public suspend fun intervalInSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intervalInSeconds = mapped
    }

    /**
     * @param value The path relative to the endpoint domain name used to probe for endpoint health.
     */
    @JvmName("ywgqnlrcwnvfygck")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The TCP port used to probe for endpoint health.
     */
    @JvmName("ghrxpxmrpgifiasq")
    public suspend fun port(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The profile-level monitoring status of the Traffic Manager profile.
     */
    @JvmName("uhmvgnaljuoeqqug")
    public suspend fun profileMonitorStatus(`value`: Either<String, ProfileMonitorStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileMonitorStatus = mapped
    }

    /**
     * @param value The profile-level monitoring status of the Traffic Manager profile.
     */
    @JvmName("ecctrmfxqnahlqdl")
    public fun profileMonitorStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProfileMonitorStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profileMonitorStatus = mapped
    }

    /**
     * @param value The profile-level monitoring status of the Traffic Manager profile.
     */
    @JvmName("fiuqyjcrcaodvxbc")
    public fun profileMonitorStatus(`value`: ProfileMonitorStatus) {
        val toBeMapped = Either.ofRight<String, ProfileMonitorStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profileMonitorStatus = mapped
    }

    /**
     * @param value The protocol (HTTP, HTTPS or TCP) used to probe for endpoint health.
     */
    @JvmName("gbvesvpxrojynofd")
    public suspend fun protocol(`value`: Either<String, MonitorProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol (HTTP, HTTPS or TCP) used to probe for endpoint health.
     */
    @JvmName("baxefcehkleopark")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MonitorProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol (HTTP, HTTPS or TCP) used to probe for endpoint health.
     */
    @JvmName("tkwyurynrpeygxqi")
    public fun protocol(`value`: MonitorProtocol) {
        val toBeMapped = Either.ofRight<String, MonitorProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The monitor timeout for endpoints in this profile. This is the time that Traffic Manager allows endpoints in this profile to response to the health check.
     */
    @JvmName("uqbpeoycslikvjif")
    public suspend fun timeoutInSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInSeconds = mapped
    }

    /**
     * @param value The number of consecutive failed health check that Traffic Manager tolerates before declaring an endpoint in this profile Degraded after the next failed health check.
     */
    @JvmName("ttfspvsaasasqqhp")
    public suspend fun toleratedNumberOfFailures(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toleratedNumberOfFailures = mapped
    }

    internal fun build(): MonitorConfigArgs = MonitorConfigArgs(
        customHeaders = customHeaders,
        expectedStatusCodeRanges = expectedStatusCodeRanges,
        intervalInSeconds = intervalInSeconds,
        path = path,
        port = port,
        profileMonitorStatus = profileMonitorStatus,
        protocol = protocol,
        timeoutInSeconds = timeoutInSeconds,
        toleratedNumberOfFailures = toleratedNumberOfFailures,
    )
}
