@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.MonitorConfigExpectedStatusCodeRangesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Min and max value of a status code range.
 * @property max Max status code.
 * @property min Min status code.
 */
public data class MonitorConfigExpectedStatusCodeRangesArgs(
    public val max: Output<Int>? = null,
    public val min: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.MonitorConfigExpectedStatusCodeRangesArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.MonitorConfigExpectedStatusCodeRangesArgs =
        com.pulumi.azurenative.network.inputs.MonitorConfigExpectedStatusCodeRangesArgs.builder()
            .max(max?.applyValue({ args0 -> args0 }))
            .min(min?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonitorConfigExpectedStatusCodeRangesArgs].
 */
@PulumiTagMarker
public class MonitorConfigExpectedStatusCodeRangesArgsBuilder internal constructor() {
    private var max: Output<Int>? = null

    private var min: Output<Int>? = null

    /**
     * @param value Max status code.
     */
    @JvmName("kplqpspliaaruxtc")
    public suspend fun max(`value`: Output<Int>) {
        this.max = value
    }

    /**
     * @param value Min status code.
     */
    @JvmName("cpxcxxpmnqxsyrlp")
    public suspend fun min(`value`: Output<Int>) {
        this.min = value
    }

    /**
     * @param value Max status code.
     */
    @JvmName("xpyxbfmpuurewavw")
    public suspend fun max(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.max = mapped
    }

    /**
     * @param value Min status code.
     */
    @JvmName("pdyergsabmbveypn")
    public suspend fun min(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.min = mapped
    }

    internal fun build(): MonitorConfigExpectedStatusCodeRangesArgs =
        MonitorConfigExpectedStatusCodeRangesArgs(
            max = max,
            min = min,
        )
}
