@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.MxRecordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An MX record.
 * @property exchange The domain name of the mail host for this MX record.
 * @property preference The preference value for this MX record.
 */
public data class MxRecordArgs(
    public val exchange: Output<String>? = null,
    public val preference: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.MxRecordArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.MxRecordArgs =
        com.pulumi.azurenative.network.inputs.MxRecordArgs.builder()
            .exchange(exchange?.applyValue({ args0 -> args0 }))
            .preference(preference?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MxRecordArgs].
 */
@PulumiTagMarker
public class MxRecordArgsBuilder internal constructor() {
    private var exchange: Output<String>? = null

    private var preference: Output<Int>? = null

    /**
     * @param value The domain name of the mail host for this MX record.
     */
    @JvmName("liixrwfscxlmrrnk")
    public suspend fun exchange(`value`: Output<String>) {
        this.exchange = value
    }

    /**
     * @param value The preference value for this MX record.
     */
    @JvmName("ubjysggwllbovfhx")
    public suspend fun preference(`value`: Output<Int>) {
        this.preference = value
    }

    /**
     * @param value The domain name of the mail host for this MX record.
     */
    @JvmName("rmlimegoeanjgahw")
    public suspend fun exchange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exchange = mapped
    }

    /**
     * @param value The preference value for this MX record.
     */
    @JvmName("rppbqqgkgqxmcinn")
    public suspend fun preference(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preference = mapped
    }

    internal fun build(): MxRecordArgs = MxRecordArgs(
        exchange = exchange,
        preference = preference,
    )
}
