@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.NetworkInterfaceDnsSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * DNS settings of a network interface.
 * @property dnsServers List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
 * @property internalDnsNameLabel Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
 */
public data class NetworkInterfaceDnsSettingsArgs(
    public val dnsServers: Output<List<String>>? = null,
    public val internalDnsNameLabel: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.NetworkInterfaceDnsSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.NetworkInterfaceDnsSettingsArgs =
        com.pulumi.azurenative.network.inputs.NetworkInterfaceDnsSettingsArgs.builder()
            .dnsServers(dnsServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .internalDnsNameLabel(internalDnsNameLabel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkInterfaceDnsSettingsArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceDnsSettingsArgsBuilder internal constructor() {
    private var dnsServers: Output<List<String>>? = null

    private var internalDnsNameLabel: Output<String>? = null

    /**
     * @param value List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
     */
    @JvmName("ggjxxofjsjtfwdrg")
    public suspend fun dnsServers(`value`: Output<List<String>>) {
        this.dnsServers = value
    }

    @JvmName("dqdbnjpklxxwdboh")
    public suspend fun dnsServers(vararg values: Output<String>) {
        this.dnsServers = Output.all(values.asList())
    }

    /**
     * @param values List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
     */
    @JvmName("skphcrfsrtrctikw")
    public suspend fun dnsServers(values: List<Output<String>>) {
        this.dnsServers = Output.all(values)
    }

    /**
     * @param value Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
     */
    @JvmName("xvbrdbmodbyvnxqw")
    public suspend fun internalDnsNameLabel(`value`: Output<String>) {
        this.internalDnsNameLabel = value
    }

    /**
     * @param value List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
     */
    @JvmName("kjblohsaptqnasav")
    public suspend fun dnsServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param values List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
     */
    @JvmName("lalutxrmwrdcdhet")
    public suspend fun dnsServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param value Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
     */
    @JvmName("welahalputysxfna")
    public suspend fun internalDnsNameLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internalDnsNameLabel = mapped
    }

    internal fun build(): NetworkInterfaceDnsSettingsArgs = NetworkInterfaceDnsSettingsArgs(
        dnsServers = dnsServers,
        internalDnsNameLabel = internalDnsNameLabel,
    )
}
