@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.O365PolicyPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Office365 breakout policy.
 * @property breakOutCategories Office365 breakout categories.
 */
public data class O365PolicyPropertiesArgs(
    public val breakOutCategories: Output<O365BreakOutCategoryPoliciesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.O365PolicyPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.O365PolicyPropertiesArgs =
        com.pulumi.azurenative.network.inputs.O365PolicyPropertiesArgs.builder()
            .breakOutCategories(
                breakOutCategories?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [O365PolicyPropertiesArgs].
 */
@PulumiTagMarker
public class O365PolicyPropertiesArgsBuilder internal constructor() {
    private var breakOutCategories: Output<O365BreakOutCategoryPoliciesArgs>? = null

    /**
     * @param value Office365 breakout categories.
     */
    @JvmName("nupxixjicitfpgwq")
    public suspend fun breakOutCategories(`value`: Output<O365BreakOutCategoryPoliciesArgs>) {
        this.breakOutCategories = value
    }

    /**
     * @param value Office365 breakout categories.
     */
    @JvmName("vegjtodnxbmutcqb")
    public suspend fun breakOutCategories(`value`: O365BreakOutCategoryPoliciesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.breakOutCategories = mapped
    }

    /**
     * @param argument Office365 breakout categories.
     */
    @JvmName("tdnoqiryffthrdhq")
    public suspend
    fun breakOutCategories(argument: suspend O365BreakOutCategoryPoliciesArgsBuilder.() -> Unit) {
        val toBeMapped = O365BreakOutCategoryPoliciesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.breakOutCategories = mapped
    }

    internal fun build(): O365PolicyPropertiesArgs = O365PolicyPropertiesArgs(
        breakOutCategories = breakOutCategories,
    )
}
