@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.Office365PolicyPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Network Virtual Appliance Sku Properties.
 * @property breakOutCategories Office 365 breakout categories.
 */
public data class Office365PolicyPropertiesArgs(
    public val breakOutCategories: Output<BreakOutCategoryPoliciesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.Office365PolicyPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.Office365PolicyPropertiesArgs =
        com.pulumi.azurenative.network.inputs.Office365PolicyPropertiesArgs.builder()
            .breakOutCategories(
                breakOutCategories?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [Office365PolicyPropertiesArgs].
 */
@PulumiTagMarker
public class Office365PolicyPropertiesArgsBuilder internal constructor() {
    private var breakOutCategories: Output<BreakOutCategoryPoliciesArgs>? = null

    /**
     * @param value Office 365 breakout categories.
     */
    @JvmName("wkcenqpgqtoxwxqk")
    public suspend fun breakOutCategories(`value`: Output<BreakOutCategoryPoliciesArgs>) {
        this.breakOutCategories = value
    }

    /**
     * @param value Office 365 breakout categories.
     */
    @JvmName("gmypqrphckhpcgys")
    public suspend fun breakOutCategories(`value`: BreakOutCategoryPoliciesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.breakOutCategories = mapped
    }

    /**
     * @param argument Office 365 breakout categories.
     */
    @JvmName("bookntbhsoxkloug")
    public suspend
    fun breakOutCategories(argument: suspend BreakOutCategoryPoliciesArgsBuilder.() -> Unit) {
        val toBeMapped = BreakOutCategoryPoliciesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.breakOutCategories = mapped
    }

    internal fun build(): Office365PolicyPropertiesArgs = Office365PolicyPropertiesArgs(
        breakOutCategories = breakOutCategories,
    )
}
