@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.OrderBy.builder
import com.pulumi.azurenative.network.kotlin.enums.FirewallPolicyIDPSQuerySortOrder
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a column to sort
 * @property field Describes the actual column name to sort by
 * @property order Describes if results should be in ascending/descending order
 */
public data class OrderBy(
    public val `field`: String? = null,
    public val order: Either<String, FirewallPolicyIDPSQuerySortOrder>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.OrderBy> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.OrderBy =
        com.pulumi.azurenative.network.inputs.OrderBy.builder()
            .`field`(`field`?.let({ args0 -> args0 }))
            .order(
                order?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [OrderBy].
 */
@PulumiTagMarker
public class OrderByBuilder internal constructor() {
    private var `field`: String? = null

    private var order: Either<String, FirewallPolicyIDPSQuerySortOrder>? = null

    /**
     * @param value Describes the actual column name to sort by
     */
    @JvmName("kfyhohoioggcjqpe")
    public suspend fun `field`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.`field` = mapped
    }

    /**
     * @param value Describes if results should be in ascending/descending order
     */
    @JvmName("pebenhvcljdwlkld")
    public suspend fun order(`value`: Either<String, FirewallPolicyIDPSQuerySortOrder>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.order = mapped
    }

    /**
     * @param value Describes if results should be in ascending/descending order
     */
    @JvmName("yqnesxnqhubtskbl")
    public fun order(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FirewallPolicyIDPSQuerySortOrder>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.order = mapped
    }

    /**
     * @param value Describes if results should be in ascending/descending order
     */
    @JvmName("xofjavckuduplejj")
    public fun order(`value`: FirewallPolicyIDPSQuerySortOrder) {
        val toBeMapped = Either.ofRight<String, FirewallPolicyIDPSQuerySortOrder>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.order = mapped
    }

    internal fun build(): OrderBy = OrderBy(
        `field` = `field`,
        order = order,
    )
}
