@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.OwaspCrsExclusionEntryArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.OwaspCrsExclusionEntryMatchVariable
import com.pulumi.azurenative.network.kotlin.enums.OwaspCrsExclusionEntrySelectorMatchOperator
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Allow to exclude some variable satisfy the condition for the WAF check.
 * @property exclusionManagedRuleSets The managed rule sets that are associated with the exclusion.
 * @property matchVariable The variable to be excluded.
 * @property selector When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
 * @property selectorMatchOperator When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
 */
public data class OwaspCrsExclusionEntryArgs(
    public val exclusionManagedRuleSets: Output<List<ExclusionManagedRuleSetArgs>>? = null,
    public val matchVariable: Output<Either<String, OwaspCrsExclusionEntryMatchVariable>>,
    public val selector: Output<String>,
    public val selectorMatchOperator:
    Output<Either<String, OwaspCrsExclusionEntrySelectorMatchOperator>>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.OwaspCrsExclusionEntryArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.OwaspCrsExclusionEntryArgs =
        com.pulumi.azurenative.network.inputs.OwaspCrsExclusionEntryArgs.builder()
            .exclusionManagedRuleSets(
                exclusionManagedRuleSets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .matchVariable(
                matchVariable.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .selector(selector.applyValue({ args0 -> args0 }))
            .selectorMatchOperator(
                selectorMatchOperator.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [OwaspCrsExclusionEntryArgs].
 */
@PulumiTagMarker
public class OwaspCrsExclusionEntryArgsBuilder internal constructor() {
    private var exclusionManagedRuleSets: Output<List<ExclusionManagedRuleSetArgs>>? = null

    private var matchVariable: Output<Either<String, OwaspCrsExclusionEntryMatchVariable>>? = null

    private var selector: Output<String>? = null

    private var selectorMatchOperator:
        Output<Either<String, OwaspCrsExclusionEntrySelectorMatchOperator>>? = null

    /**
     * @param value The managed rule sets that are associated with the exclusion.
     */
    @JvmName("oiaernpqfmurygjx")
    public suspend fun exclusionManagedRuleSets(`value`: Output<List<ExclusionManagedRuleSetArgs>>) {
        this.exclusionManagedRuleSets = value
    }

    @JvmName("albxqqyocthrbedl")
    public suspend fun exclusionManagedRuleSets(vararg values: Output<ExclusionManagedRuleSetArgs>) {
        this.exclusionManagedRuleSets = Output.all(values.asList())
    }

    /**
     * @param values The managed rule sets that are associated with the exclusion.
     */
    @JvmName("csoudslxjrhcqook")
    public suspend fun exclusionManagedRuleSets(values: List<Output<ExclusionManagedRuleSetArgs>>) {
        this.exclusionManagedRuleSets = Output.all(values)
    }

    /**
     * @param value The variable to be excluded.
     */
    @JvmName("lroqrwduusmyfhqm")
    public suspend
    fun matchVariable(`value`: Output<Either<String, OwaspCrsExclusionEntryMatchVariable>>) {
        this.matchVariable = value
    }

    /**
     * @param value When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
     */
    @JvmName("xavdmvhkqkwebdhh")
    public suspend fun selector(`value`: Output<String>) {
        this.selector = value
    }

    /**
     * @param value When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
     */
    @JvmName("wwupqjukdhnfkoxf")
    public suspend
    fun selectorMatchOperator(`value`: Output<Either<String, OwaspCrsExclusionEntrySelectorMatchOperator>>) {
        this.selectorMatchOperator = value
    }

    /**
     * @param value The managed rule sets that are associated with the exclusion.
     */
    @JvmName("wkrxbrotnxgxdvwx")
    public suspend fun exclusionManagedRuleSets(`value`: List<ExclusionManagedRuleSetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusionManagedRuleSets = mapped
    }

    /**
     * @param argument The managed rule sets that are associated with the exclusion.
     */
    @JvmName("fqteiuktwgakdlfh")
    public suspend
    fun exclusionManagedRuleSets(argument: List<suspend ExclusionManagedRuleSetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExclusionManagedRuleSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.exclusionManagedRuleSets = mapped
    }

    /**
     * @param argument The managed rule sets that are associated with the exclusion.
     */
    @JvmName("fyrbxufairlxktmh")
    public suspend fun exclusionManagedRuleSets(
        vararg
        argument: suspend ExclusionManagedRuleSetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ExclusionManagedRuleSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.exclusionManagedRuleSets = mapped
    }

    /**
     * @param argument The managed rule sets that are associated with the exclusion.
     */
    @JvmName("qpeuqsmulefnihay")
    public suspend
    fun exclusionManagedRuleSets(argument: suspend ExclusionManagedRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExclusionManagedRuleSetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.exclusionManagedRuleSets = mapped
    }

    /**
     * @param values The managed rule sets that are associated with the exclusion.
     */
    @JvmName("lakqgfofkemnowbv")
    public suspend fun exclusionManagedRuleSets(vararg values: ExclusionManagedRuleSetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exclusionManagedRuleSets = mapped
    }

    /**
     * @param value The variable to be excluded.
     */
    @JvmName("ooujvrcftfowvhpe")
    public suspend fun matchVariable(`value`: Either<String, OwaspCrsExclusionEntryMatchVariable>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariable = mapped
    }

    /**
     * @param value The variable to be excluded.
     */
    @JvmName("lqlkatkxqsrlcdct")
    public fun matchVariable(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OwaspCrsExclusionEntryMatchVariable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariable = mapped
    }

    /**
     * @param value The variable to be excluded.
     */
    @JvmName("tgidmdnyupkhyaty")
    public fun matchVariable(`value`: OwaspCrsExclusionEntryMatchVariable) {
        val toBeMapped = Either.ofRight<String, OwaspCrsExclusionEntryMatchVariable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariable = mapped
    }

    /**
     * @param value When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
     */
    @JvmName("ggetygdrqiolflhm")
    public suspend fun selector(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selector = mapped
    }

    /**
     * @param value When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
     */
    @JvmName("boaiubklibyigirh")
    public suspend
    fun selectorMatchOperator(`value`: Either<String, OwaspCrsExclusionEntrySelectorMatchOperator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectorMatchOperator = mapped
    }

    /**
     * @param value When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
     */
    @JvmName("rolocifgbifpjqwk")
    public fun selectorMatchOperator(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OwaspCrsExclusionEntrySelectorMatchOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectorMatchOperator = mapped
    }

    /**
     * @param value When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
     */
    @JvmName("edohcitgtxplmgxe")
    public fun selectorMatchOperator(`value`: OwaspCrsExclusionEntrySelectorMatchOperator) {
        val toBeMapped = Either.ofRight<String, OwaspCrsExclusionEntrySelectorMatchOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectorMatchOperator = mapped
    }

    internal fun build(): OwaspCrsExclusionEntryArgs = OwaspCrsExclusionEntryArgs(
        exclusionManagedRuleSets = exclusionManagedRuleSets,
        matchVariable = matchVariable ?: throw PulumiNullFieldException("matchVariable"),
        selector = selector ?: throw PulumiNullFieldException("selector"),
        selectorMatchOperator = selectorMatchOperator ?: throw
            PulumiNullFieldException("selectorMatchOperator"),
    )
}
