@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.P2SConnectionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * P2SConnectionConfiguration Resource.
 * @property enableInternetSecurity Flag indicating whether the enable internet security flag is turned on for the P2S Connections or not.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property routingConfiguration The Routing Configuration indicating the associated and propagated route tables on this connection.
 * @property vpnClientAddressPool The reference to the address space resource which represents Address space for P2S VpnClient.
 */
public data class P2SConnectionConfigurationArgs(
    public val enableInternetSecurity: Output<Boolean>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val routingConfiguration: Output<RoutingConfigurationArgs>? = null,
    public val vpnClientAddressPool: Output<AddressSpaceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.P2SConnectionConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.P2SConnectionConfigurationArgs =
        com.pulumi.azurenative.network.inputs.P2SConnectionConfigurationArgs.builder()
            .enableInternetSecurity(enableInternetSecurity?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .routingConfiguration(
                routingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vpnClientAddressPool(
                vpnClientAddressPool?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [P2SConnectionConfigurationArgs].
 */
@PulumiTagMarker
public class P2SConnectionConfigurationArgsBuilder internal constructor() {
    private var enableInternetSecurity: Output<Boolean>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var routingConfiguration: Output<RoutingConfigurationArgs>? = null

    private var vpnClientAddressPool: Output<AddressSpaceArgs>? = null

    /**
     * @param value Flag indicating whether the enable internet security flag is turned on for the P2S Connections or not.
     */
    @JvmName("abhnomeejwtprqxt")
    public suspend fun enableInternetSecurity(`value`: Output<Boolean>) {
        this.enableInternetSecurity = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("lfmcwufxvkjknbrv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("gyhtcidafevodaek")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("ypcegfmcoonqaqgk")
    public suspend fun routingConfiguration(`value`: Output<RoutingConfigurationArgs>) {
        this.routingConfiguration = value
    }

    /**
     * @param value The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    @JvmName("otghofygawonphok")
    public suspend fun vpnClientAddressPool(`value`: Output<AddressSpaceArgs>) {
        this.vpnClientAddressPool = value
    }

    /**
     * @param value Flag indicating whether the enable internet security flag is turned on for the P2S Connections or not.
     */
    @JvmName("jsoehdmscmwplejg")
    public suspend fun enableInternetSecurity(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableInternetSecurity = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("puxynebuukjeejlo")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("ccgkgkxtlovhyjtm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("khqfekemnlhbftas")
    public suspend fun routingConfiguration(`value`: RoutingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingConfiguration = mapped
    }

    /**
     * @param argument The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("yakgtiijiovkfpbf")
    public suspend
    fun routingConfiguration(argument: suspend RoutingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RoutingConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routingConfiguration = mapped
    }

    /**
     * @param value The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    @JvmName("bsneanxhuhxkaxuq")
    public suspend fun vpnClientAddressPool(`value`: AddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientAddressPool = mapped
    }

    /**
     * @param argument The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    @JvmName("dphdectenkfgytuv")
    public suspend fun vpnClientAddressPool(argument: suspend AddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = AddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpnClientAddressPool = mapped
    }

    internal fun build(): P2SConnectionConfigurationArgs = P2SConnectionConfigurationArgs(
        enableInternetSecurity = enableInternetSecurity,
        id = id,
        name = name,
        routingConfiguration = routingConfiguration,
        vpnClientAddressPool = vpnClientAddressPool,
    )
}
