@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PolicySettingsArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.WebApplicationFirewallEnabledState
import com.pulumi.azurenative.network.kotlin.enums.WebApplicationFirewallMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines contents of a web application firewall global configuration.
 * @property customBlockResponseBody If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
 * @property customBlockResponseStatusCode If the action type is block, customer can override the response status code.
 * @property fileUploadEnforcement Whether allow WAF to enforce file upload limits.
 * @property fileUploadLimitInMb Maximum file upload size in Mb for WAF.
 * @property logScrubbing To scrub sensitive log fields
 * @property maxRequestBodySizeInKb Maximum request body size in Kb for WAF.
 * @property mode The mode of the policy.
 * @property requestBodyCheck Whether to allow WAF to check request Body.
 * @property requestBodyEnforcement Whether allow WAF to enforce request body limits.
 * @property requestBodyInspectLimitInKB Max inspection limit in KB for request body inspection for WAF.
 * @property state The state of the policy.
 */
public data class PolicySettingsArgs(
    public val customBlockResponseBody: Output<String>? = null,
    public val customBlockResponseStatusCode: Output<Int>? = null,
    public val fileUploadEnforcement: Output<Boolean>? = null,
    public val fileUploadLimitInMb: Output<Int>? = null,
    public val logScrubbing: Output<PolicySettingsLogScrubbingArgs>? = null,
    public val maxRequestBodySizeInKb: Output<Int>? = null,
    public val mode: Output<Either<String, WebApplicationFirewallMode>>? = null,
    public val requestBodyCheck: Output<Boolean>? = null,
    public val requestBodyEnforcement: Output<Boolean>? = null,
    public val requestBodyInspectLimitInKB: Output<Int>? = null,
    public val state: Output<Either<String, WebApplicationFirewallEnabledState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PolicySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PolicySettingsArgs =
        com.pulumi.azurenative.network.inputs.PolicySettingsArgs.builder()
            .customBlockResponseBody(customBlockResponseBody?.applyValue({ args0 -> args0 }))
            .customBlockResponseStatusCode(customBlockResponseStatusCode?.applyValue({ args0 -> args0 }))
            .fileUploadEnforcement(fileUploadEnforcement?.applyValue({ args0 -> args0 }))
            .fileUploadLimitInMb(fileUploadLimitInMb?.applyValue({ args0 -> args0 }))
            .logScrubbing(logScrubbing?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maxRequestBodySizeInKb(maxRequestBodySizeInKb?.applyValue({ args0 -> args0 }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .requestBodyCheck(requestBodyCheck?.applyValue({ args0 -> args0 }))
            .requestBodyEnforcement(requestBodyEnforcement?.applyValue({ args0 -> args0 }))
            .requestBodyInspectLimitInKB(requestBodyInspectLimitInKB?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicySettingsArgs].
 */
@PulumiTagMarker
public class PolicySettingsArgsBuilder internal constructor() {
    private var customBlockResponseBody: Output<String>? = null

    private var customBlockResponseStatusCode: Output<Int>? = null

    private var fileUploadEnforcement: Output<Boolean>? = null

    private var fileUploadLimitInMb: Output<Int>? = null

    private var logScrubbing: Output<PolicySettingsLogScrubbingArgs>? = null

    private var maxRequestBodySizeInKb: Output<Int>? = null

    private var mode: Output<Either<String, WebApplicationFirewallMode>>? = null

    private var requestBodyCheck: Output<Boolean>? = null

    private var requestBodyEnforcement: Output<Boolean>? = null

    private var requestBodyInspectLimitInKB: Output<Int>? = null

    private var state: Output<Either<String, WebApplicationFirewallEnabledState>>? = null

    /**
     * @param value If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
     */
    @JvmName("loqqjmehnoihbgwq")
    public suspend fun customBlockResponseBody(`value`: Output<String>) {
        this.customBlockResponseBody = value
    }

    /**
     * @param value If the action type is block, customer can override the response status code.
     */
    @JvmName("iirgawrjbluloppr")
    public suspend fun customBlockResponseStatusCode(`value`: Output<Int>) {
        this.customBlockResponseStatusCode = value
    }

    /**
     * @param value Whether allow WAF to enforce file upload limits.
     */
    @JvmName("vsqriaewlebnktlv")
    public suspend fun fileUploadEnforcement(`value`: Output<Boolean>) {
        this.fileUploadEnforcement = value
    }

    /**
     * @param value Maximum file upload size in Mb for WAF.
     */
    @JvmName("yduyelnnkhbjmhmh")
    public suspend fun fileUploadLimitInMb(`value`: Output<Int>) {
        this.fileUploadLimitInMb = value
    }

    /**
     * @param value To scrub sensitive log fields
     */
    @JvmName("clrhvduqhqvbobpe")
    public suspend fun logScrubbing(`value`: Output<PolicySettingsLogScrubbingArgs>) {
        this.logScrubbing = value
    }

    /**
     * @param value Maximum request body size in Kb for WAF.
     */
    @JvmName("kdlpvchnewecwpkg")
    public suspend fun maxRequestBodySizeInKb(`value`: Output<Int>) {
        this.maxRequestBodySizeInKb = value
    }

    /**
     * @param value The mode of the policy.
     */
    @JvmName("cfwuxvpgrnrtwric")
    public suspend fun mode(`value`: Output<Either<String, WebApplicationFirewallMode>>) {
        this.mode = value
    }

    /**
     * @param value Whether to allow WAF to check request Body.
     */
    @JvmName("pplaydddwyvkaljq")
    public suspend fun requestBodyCheck(`value`: Output<Boolean>) {
        this.requestBodyCheck = value
    }

    /**
     * @param value Whether allow WAF to enforce request body limits.
     */
    @JvmName("csxsgyjbjlwtmcfb")
    public suspend fun requestBodyEnforcement(`value`: Output<Boolean>) {
        this.requestBodyEnforcement = value
    }

    /**
     * @param value Max inspection limit in KB for request body inspection for WAF.
     */
    @JvmName("vufuqkgtjovbnigj")
    public suspend fun requestBodyInspectLimitInKB(`value`: Output<Int>) {
        this.requestBodyInspectLimitInKB = value
    }

    /**
     * @param value The state of the policy.
     */
    @JvmName("woeblpjjwshidllr")
    public suspend fun state(`value`: Output<Either<String, WebApplicationFirewallEnabledState>>) {
        this.state = value
    }

    /**
     * @param value If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
     */
    @JvmName("iwqhwilgceoniudv")
    public suspend fun customBlockResponseBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customBlockResponseBody = mapped
    }

    /**
     * @param value If the action type is block, customer can override the response status code.
     */
    @JvmName("jjrpihbymsqpeknn")
    public suspend fun customBlockResponseStatusCode(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customBlockResponseStatusCode = mapped
    }

    /**
     * @param value Whether allow WAF to enforce file upload limits.
     */
    @JvmName("xxmpjnvkudgbtijh")
    public suspend fun fileUploadEnforcement(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileUploadEnforcement = mapped
    }

    /**
     * @param value Maximum file upload size in Mb for WAF.
     */
    @JvmName("lwskoaiuvjfxedgb")
    public suspend fun fileUploadLimitInMb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileUploadLimitInMb = mapped
    }

    /**
     * @param value To scrub sensitive log fields
     */
    @JvmName("csqydhnujqamjpaa")
    public suspend fun logScrubbing(`value`: PolicySettingsLogScrubbingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logScrubbing = mapped
    }

    /**
     * @param argument To scrub sensitive log fields
     */
    @JvmName("ugwjpiblintvneyt")
    public suspend
    fun logScrubbing(argument: suspend PolicySettingsLogScrubbingArgsBuilder.() -> Unit) {
        val toBeMapped = PolicySettingsLogScrubbingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logScrubbing = mapped
    }

    /**
     * @param value Maximum request body size in Kb for WAF.
     */
    @JvmName("cqwvwgncrwxqdqyc")
    public suspend fun maxRequestBodySizeInKb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRequestBodySizeInKb = mapped
    }

    /**
     * @param value The mode of the policy.
     */
    @JvmName("figpsuxujqftewsu")
    public suspend fun mode(`value`: Either<String, WebApplicationFirewallMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The mode of the policy.
     */
    @JvmName("rxpqfuvlduyeaaqi")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WebApplicationFirewallMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The mode of the policy.
     */
    @JvmName("embhqejvvxhatvcj")
    public fun mode(`value`: WebApplicationFirewallMode) {
        val toBeMapped = Either.ofRight<String, WebApplicationFirewallMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Whether to allow WAF to check request Body.
     */
    @JvmName("ldijywbcxtxprnxt")
    public suspend fun requestBodyCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestBodyCheck = mapped
    }

    /**
     * @param value Whether allow WAF to enforce request body limits.
     */
    @JvmName("hkdornbqjisddwpt")
    public suspend fun requestBodyEnforcement(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestBodyEnforcement = mapped
    }

    /**
     * @param value Max inspection limit in KB for request body inspection for WAF.
     */
    @JvmName("qwafidaxkchrundp")
    public suspend fun requestBodyInspectLimitInKB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestBodyInspectLimitInKB = mapped
    }

    /**
     * @param value The state of the policy.
     */
    @JvmName("tosbqvpiapturncd")
    public suspend fun state(`value`: Either<String, WebApplicationFirewallEnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The state of the policy.
     */
    @JvmName("rshnnwoasnyahwsh")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WebApplicationFirewallEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The state of the policy.
     */
    @JvmName("dvonohsjbftpnqjc")
    public fun state(`value`: WebApplicationFirewallEnabledState) {
        val toBeMapped = Either.ofRight<String, WebApplicationFirewallEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): PolicySettingsArgs = PolicySettingsArgs(
        customBlockResponseBody = customBlockResponseBody,
        customBlockResponseStatusCode = customBlockResponseStatusCode,
        fileUploadEnforcement = fileUploadEnforcement,
        fileUploadLimitInMb = fileUploadLimitInMb,
        logScrubbing = logScrubbing,
        maxRequestBodySizeInKb = maxRequestBodySizeInKb,
        mode = mode,
        requestBodyCheck = requestBodyCheck,
        requestBodyEnforcement = requestBodyEnforcement,
        requestBodyInspectLimitInKB = requestBodyInspectLimitInKB,
        state = state,
    )
}
