@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PrivateLinkServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Private link service resource.
 * @property autoApproval The auto-approval list of the private link service.
 * @property enableProxyProtocol Whether the private link service is enabled for proxy protocol or not.
 * @property extendedLocation The extended location of the load balancer.
 * @property fqdns The list of Fqdn.
 * @property id Resource ID.
 * @property ipConfigurations An array of private link service IP configurations.
 * @property loadBalancerFrontendIpConfigurations An array of references to the load balancer IP configurations.
 * @property location Resource location.
 * @property tags Resource tags.
 * @property visibility The visibility list of the private link service.
 */
public data class PrivateLinkServiceArgs(
    public val autoApproval: Output<PrivateLinkServicePropertiesAutoApprovalArgs>? = null,
    public val enableProxyProtocol: Output<Boolean>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val fqdns: Output<List<String>>? = null,
    public val id: Output<String>? = null,
    public val ipConfigurations: Output<List<PrivateLinkServiceIpConfigurationArgs>>? = null,
    public val loadBalancerFrontendIpConfigurations: Output<List<FrontendIPConfigurationArgs>>? =
        null,
    public val location: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val visibility: Output<PrivateLinkServicePropertiesVisibilityArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PrivateLinkServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PrivateLinkServiceArgs =
        com.pulumi.azurenative.network.inputs.PrivateLinkServiceArgs.builder()
            .autoApproval(autoApproval?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enableProxyProtocol(enableProxyProtocol?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fqdns(fqdns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ipConfigurations(
                ipConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .loadBalancerFrontendIpConfigurations(
                loadBalancerFrontendIpConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .visibility(visibility?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PrivateLinkServiceArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceArgsBuilder internal constructor() {
    private var autoApproval: Output<PrivateLinkServicePropertiesAutoApprovalArgs>? = null

    private var enableProxyProtocol: Output<Boolean>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var fqdns: Output<List<String>>? = null

    private var id: Output<String>? = null

    private var ipConfigurations: Output<List<PrivateLinkServiceIpConfigurationArgs>>? = null

    private var loadBalancerFrontendIpConfigurations: Output<List<FrontendIPConfigurationArgs>>? =
        null

    private var location: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var visibility: Output<PrivateLinkServicePropertiesVisibilityArgs>? = null

    /**
     * @param value The auto-approval list of the private link service.
     */
    @JvmName("mdabhcjxkcvdkdtq")
    public suspend fun autoApproval(`value`: Output<PrivateLinkServicePropertiesAutoApprovalArgs>) {
        this.autoApproval = value
    }

    /**
     * @param value Whether the private link service is enabled for proxy protocol or not.
     */
    @JvmName("smugibjijaqsggrv")
    public suspend fun enableProxyProtocol(`value`: Output<Boolean>) {
        this.enableProxyProtocol = value
    }

    /**
     * @param value The extended location of the load balancer.
     */
    @JvmName("nealjddwotrmgtfe")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The list of Fqdn.
     */
    @JvmName("aqunaqcpueyqtdss")
    public suspend fun fqdns(`value`: Output<List<String>>) {
        this.fqdns = value
    }

    @JvmName("ywjmhgobqeqpynnr")
    public suspend fun fqdns(vararg values: Output<String>) {
        this.fqdns = Output.all(values.asList())
    }

    /**
     * @param values The list of Fqdn.
     */
    @JvmName("kbgrjrmrifaoxktm")
    public suspend fun fqdns(values: List<Output<String>>) {
        this.fqdns = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ojdqtrsedfnrnchp")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value An array of private link service IP configurations.
     */
    @JvmName("prpfabhgavarrqys")
    public suspend
    fun ipConfigurations(`value`: Output<List<PrivateLinkServiceIpConfigurationArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("ofjwecvarvdccows")
    public suspend fun ipConfigurations(
        vararg
        values: Output<PrivateLinkServiceIpConfigurationArgs>,
    ) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values An array of private link service IP configurations.
     */
    @JvmName("jggcxoklqkocfbbr")
    public suspend fun ipConfigurations(values: List<Output<PrivateLinkServiceIpConfigurationArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value An array of references to the load balancer IP configurations.
     */
    @JvmName("ekmnpnpooykbrkex")
    public suspend
    fun loadBalancerFrontendIpConfigurations(`value`: Output<List<FrontendIPConfigurationArgs>>) {
        this.loadBalancerFrontendIpConfigurations = value
    }

    @JvmName("jowoohcwxiuptfrq")
    public suspend fun loadBalancerFrontendIpConfigurations(
        vararg
        values: Output<FrontendIPConfigurationArgs>,
    ) {
        this.loadBalancerFrontendIpConfigurations = Output.all(values.asList())
    }

    /**
     * @param values An array of references to the load balancer IP configurations.
     */
    @JvmName("ihgkkblpnqqgjcne")
    public suspend
    fun loadBalancerFrontendIpConfigurations(values: List<Output<FrontendIPConfigurationArgs>>) {
        this.loadBalancerFrontendIpConfigurations = Output.all(values)
    }

    /**
     * @param value Resource location.
     */
    @JvmName("aeyijebloecldpti")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xgwbggmgawiwxmoa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The visibility list of the private link service.
     */
    @JvmName("vcbortlsjkqubslr")
    public suspend fun visibility(`value`: Output<PrivateLinkServicePropertiesVisibilityArgs>) {
        this.visibility = value
    }

    /**
     * @param value The auto-approval list of the private link service.
     */
    @JvmName("xasrulcaafnsxveg")
    public suspend fun autoApproval(`value`: PrivateLinkServicePropertiesAutoApprovalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoApproval = mapped
    }

    /**
     * @param argument The auto-approval list of the private link service.
     */
    @JvmName("iyicsfigmehpeebd")
    public suspend
    fun autoApproval(argument: suspend PrivateLinkServicePropertiesAutoApprovalArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServicePropertiesAutoApprovalArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoApproval = mapped
    }

    /**
     * @param value Whether the private link service is enabled for proxy protocol or not.
     */
    @JvmName("fikischfmdxvqytd")
    public suspend fun enableProxyProtocol(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableProxyProtocol = mapped
    }

    /**
     * @param value The extended location of the load balancer.
     */
    @JvmName("ttfvgkgtcbgbfigg")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the load balancer.
     */
    @JvmName("xjvafjrjkdbnkplr")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The list of Fqdn.
     */
    @JvmName("slaqtlgqkpgudlfp")
    public suspend fun fqdns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdns = mapped
    }

    /**
     * @param values The list of Fqdn.
     */
    @JvmName("fwbovugeuisfahas")
    public suspend fun fqdns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fqdns = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("bxalkmcgdlvqqipq")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value An array of private link service IP configurations.
     */
    @JvmName("gkcfgynrblycksbj")
    public suspend fun ipConfigurations(`value`: List<PrivateLinkServiceIpConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument An array of private link service IP configurations.
     */
    @JvmName("kkachpgfmimyqvaa")
    public suspend
    fun ipConfigurations(argument: List<suspend PrivateLinkServiceIpConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceIpConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument An array of private link service IP configurations.
     */
    @JvmName("aixasptfxfosimjq")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend PrivateLinkServiceIpConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceIpConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument An array of private link service IP configurations.
     */
    @JvmName("ohonvlkidshwtqho")
    public suspend
    fun ipConfigurations(argument: suspend PrivateLinkServiceIpConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateLinkServiceIpConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values An array of private link service IP configurations.
     */
    @JvmName("xdssqruddevpesmj")
    public suspend fun ipConfigurations(vararg values: PrivateLinkServiceIpConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value An array of references to the load balancer IP configurations.
     */
    @JvmName("gustkhuamhtwgeul")
    public suspend
    fun loadBalancerFrontendIpConfigurations(`value`: List<FrontendIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerFrontendIpConfigurations = mapped
    }

    /**
     * @param argument An array of references to the load balancer IP configurations.
     */
    @JvmName("yoeuuprjjxykugna")
    public suspend
    fun loadBalancerFrontendIpConfigurations(argument: List<suspend FrontendIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrontendIPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerFrontendIpConfigurations = mapped
    }

    /**
     * @param argument An array of references to the load balancer IP configurations.
     */
    @JvmName("bdxktnvubxegvgfe")
    public suspend fun loadBalancerFrontendIpConfigurations(
        vararg
        argument: suspend FrontendIPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FrontendIPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerFrontendIpConfigurations = mapped
    }

    /**
     * @param argument An array of references to the load balancer IP configurations.
     */
    @JvmName("kbroquubvtnjoyfs")
    public suspend
    fun loadBalancerFrontendIpConfigurations(argument: suspend FrontendIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FrontendIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.loadBalancerFrontendIpConfigurations = mapped
    }

    /**
     * @param values An array of references to the load balancer IP configurations.
     */
    @JvmName("srnbsnaeaphdfgnr")
    public suspend fun loadBalancerFrontendIpConfigurations(
        vararg
        values: FrontendIPConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerFrontendIpConfigurations = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("qaaohbyjjvkknclv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hmctkniciojsyctn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("qdkkrojhgrurbqnk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The visibility list of the private link service.
     */
    @JvmName("dlrrgnxcfrjyhmjd")
    public suspend fun visibility(`value`: PrivateLinkServicePropertiesVisibilityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visibility = mapped
    }

    /**
     * @param argument The visibility list of the private link service.
     */
    @JvmName("lixohdpnbsjgnbws")
    public suspend
    fun visibility(argument: suspend PrivateLinkServicePropertiesVisibilityArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServicePropertiesVisibilityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.visibility = mapped
    }

    internal fun build(): PrivateLinkServiceArgs = PrivateLinkServiceArgs(
        autoApproval = autoApproval,
        enableProxyProtocol = enableProxyProtocol,
        extendedLocation = extendedLocation,
        fqdns = fqdns,
        id = id,
        ipConfigurations = ipConfigurations,
        loadBalancerFrontendIpConfigurations = loadBalancerFrontendIpConfigurations,
        location = location,
        tags = tags,
        visibility = visibility,
    )
}
