@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ProbeArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ProbeProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A load balancer probe.
 * @property id Resource ID.
 * @property intervalInSeconds The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
 * @property name The name of the resource that is unique within the set of probes used by the load balancer. This name can be used to access the resource.
 * @property numberOfProbes The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure.
 * @property port The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
 * @property probeThreshold The number of consecutive successful or failed probes in order to allow or deny traffic from being delivered to this endpoint. After failing the number of consecutive probes equal to this value, the endpoint will be taken out of rotation and require the same number of successful consecutive probes to be placed back in rotation.
 * @property protocol The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful.
 * @property requestPath The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
 */
public data class ProbeArgs(
    public val id: Output<String>? = null,
    public val intervalInSeconds: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val numberOfProbes: Output<Int>? = null,
    public val port: Output<Int>,
    public val probeThreshold: Output<Int>? = null,
    public val protocol: Output<Either<String, ProbeProtocol>>,
    public val requestPath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ProbeArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ProbeArgs =
        com.pulumi.azurenative.network.inputs.ProbeArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .intervalInSeconds(intervalInSeconds?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .numberOfProbes(numberOfProbes?.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 }))
            .probeThreshold(probeThreshold?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .requestPath(requestPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProbeArgs].
 */
@PulumiTagMarker
public class ProbeArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var intervalInSeconds: Output<Int>? = null

    private var name: Output<String>? = null

    private var numberOfProbes: Output<Int>? = null

    private var port: Output<Int>? = null

    private var probeThreshold: Output<Int>? = null

    private var protocol: Output<Either<String, ProbeProtocol>>? = null

    private var requestPath: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("dpoiyhmncmwbjypk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
     */
    @JvmName("stoekmwgfvmodagu")
    public suspend fun intervalInSeconds(`value`: Output<Int>) {
        this.intervalInSeconds = value
    }

    /**
     * @param value The name of the resource that is unique within the set of probes used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("nueppokerbjsltro")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure.
     */
    @JvmName("lqwxyrjbwgmltnac")
    public suspend fun numberOfProbes(`value`: Output<Int>) {
        this.numberOfProbes = value
    }

    /**
     * @param value The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
     */
    @JvmName("lnqnchdohcpmtwcm")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The number of consecutive successful or failed probes in order to allow or deny traffic from being delivered to this endpoint. After failing the number of consecutive probes equal to this value, the endpoint will be taken out of rotation and require the same number of successful consecutive probes to be placed back in rotation.
     */
    @JvmName("ocitqydyyfeaforl")
    public suspend fun probeThreshold(`value`: Output<Int>) {
        this.probeThreshold = value
    }

    /**
     * @param value The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful.
     */
    @JvmName("ockqudgnadhjpxor")
    public suspend fun protocol(`value`: Output<Either<String, ProbeProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
     */
    @JvmName("xqkijcjyrdqjnxou")
    public suspend fun requestPath(`value`: Output<String>) {
        this.requestPath = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ttjiefdveivijqyf")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
     */
    @JvmName("nuhbmldgwmyvccdm")
    public suspend fun intervalInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intervalInSeconds = mapped
    }

    /**
     * @param value The name of the resource that is unique within the set of probes used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("feecekdkkegdagtg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure.
     */
    @JvmName("itapvpmmviuuiixn")
    public suspend fun numberOfProbes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfProbes = mapped
    }

    /**
     * @param value The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
     */
    @JvmName("apooxrhemsqoyndr")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The number of consecutive successful or failed probes in order to allow or deny traffic from being delivered to this endpoint. After failing the number of consecutive probes equal to this value, the endpoint will be taken out of rotation and require the same number of successful consecutive probes to be placed back in rotation.
     */
    @JvmName("wmlxililyipqejuu")
    public suspend fun probeThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probeThreshold = mapped
    }

    /**
     * @param value The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful.
     */
    @JvmName("craxbwvdqebcvjmw")
    public suspend fun protocol(`value`: Either<String, ProbeProtocol>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful.
     */
    @JvmName("rcfgopfnbalhbcvv")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProbeProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful.
     */
    @JvmName("pwajpsmrekqndedd")
    public fun protocol(`value`: ProbeProtocol) {
        val toBeMapped = Either.ofRight<String, ProbeProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
     */
    @JvmName("wbhjpowqscyouqor")
    public suspend fun requestPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestPath = mapped
    }

    internal fun build(): ProbeArgs = ProbeArgs(
        id = id,
        intervalInSeconds = intervalInSeconds,
        name = name,
        numberOfProbes = numberOfProbes,
        port = port ?: throw PulumiNullFieldException("port"),
        probeThreshold = probeThreshold,
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
        requestPath = requestPath,
    )
}
