@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PublicIPAddressDnsSettingsArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.PublicIpAddressDnsSettingsDomainNameLabelScope
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains FQDN of the DNS record associated with the public IP address.
 * @property domainNameLabel The domain name label. The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
 * @property domainNameLabelScope The domain name label scope. If a domain name label and a domain name label scope are specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system with a hashed value includes in FQDN.
 * @property fqdn The Fully Qualified Domain Name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
 * @property reverseFqdn The reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
 */
public data class PublicIPAddressDnsSettingsArgs(
    public val domainNameLabel: Output<String>? = null,
    public val domainNameLabelScope: Output<PublicIpAddressDnsSettingsDomainNameLabelScope>? = null,
    public val fqdn: Output<String>? = null,
    public val reverseFqdn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PublicIPAddressDnsSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PublicIPAddressDnsSettingsArgs =
        com.pulumi.azurenative.network.inputs.PublicIPAddressDnsSettingsArgs.builder()
            .domainNameLabel(domainNameLabel?.applyValue({ args0 -> args0 }))
            .domainNameLabelScope(
                domainNameLabelScope?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .fqdn(fqdn?.applyValue({ args0 -> args0 }))
            .reverseFqdn(reverseFqdn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PublicIPAddressDnsSettingsArgs].
 */
@PulumiTagMarker
public class PublicIPAddressDnsSettingsArgsBuilder internal constructor() {
    private var domainNameLabel: Output<String>? = null

    private var domainNameLabelScope: Output<PublicIpAddressDnsSettingsDomainNameLabelScope>? = null

    private var fqdn: Output<String>? = null

    private var reverseFqdn: Output<String>? = null

    /**
     * @param value The domain name label. The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
     */
    @JvmName("xxgqrdmddohnnmwe")
    public suspend fun domainNameLabel(`value`: Output<String>) {
        this.domainNameLabel = value
    }

    /**
     * @param value The domain name label scope. If a domain name label and a domain name label scope are specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system with a hashed value includes in FQDN.
     */
    @JvmName("uvxhktrgbcfcnhqk")
    public suspend
    fun domainNameLabelScope(`value`: Output<PublicIpAddressDnsSettingsDomainNameLabelScope>) {
        this.domainNameLabelScope = value
    }

    /**
     * @param value The Fully Qualified Domain Name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
     */
    @JvmName("dicfdheowvbcqucx")
    public suspend fun fqdn(`value`: Output<String>) {
        this.fqdn = value
    }

    /**
     * @param value The reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
     */
    @JvmName("tgyyrbhuwytpwues")
    public suspend fun reverseFqdn(`value`: Output<String>) {
        this.reverseFqdn = value
    }

    /**
     * @param value The domain name label. The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
     */
    @JvmName("iqjmsbieftrkdgei")
    public suspend fun domainNameLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainNameLabel = mapped
    }

    /**
     * @param value The domain name label scope. If a domain name label and a domain name label scope are specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system with a hashed value includes in FQDN.
     */
    @JvmName("xioounpcvtaqtohj")
    public suspend
    fun domainNameLabelScope(`value`: PublicIpAddressDnsSettingsDomainNameLabelScope?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainNameLabelScope = mapped
    }

    /**
     * @param value The Fully Qualified Domain Name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
     */
    @JvmName("ytmrqplwhucvhpvt")
    public suspend fun fqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdn = mapped
    }

    /**
     * @param value The reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
     */
    @JvmName("hkptnjxurkxoylbd")
    public suspend fun reverseFqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reverseFqdn = mapped
    }

    internal fun build(): PublicIPAddressDnsSettingsArgs = PublicIPAddressDnsSettingsArgs(
        domainNameLabel = domainNameLabel,
        domainNameLabelScope = domainNameLabelScope,
        fqdn = fqdn,
        reverseFqdn = reverseFqdn,
    )
}
