@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.QosIpRangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Qos Traffic Profiler IP Range properties.
 * @property endIP End IP Address.
 * @property startIP Start IP Address.
 */
public data class QosIpRangeArgs(
    public val endIP: Output<String>? = null,
    public val startIP: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.QosIpRangeArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.QosIpRangeArgs =
        com.pulumi.azurenative.network.inputs.QosIpRangeArgs.builder()
            .endIP(endIP?.applyValue({ args0 -> args0 }))
            .startIP(startIP?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QosIpRangeArgs].
 */
@PulumiTagMarker
public class QosIpRangeArgsBuilder internal constructor() {
    private var endIP: Output<String>? = null

    private var startIP: Output<String>? = null

    /**
     * @param value End IP Address.
     */
    @JvmName("bslyjyxbpqbgauju")
    public suspend fun endIP(`value`: Output<String>) {
        this.endIP = value
    }

    /**
     * @param value Start IP Address.
     */
    @JvmName("gbpbkwjqpnprmbcs")
    public suspend fun startIP(`value`: Output<String>) {
        this.startIP = value
    }

    /**
     * @param value End IP Address.
     */
    @JvmName("kxmmqglwbhgvaspf")
    public suspend fun endIP(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endIP = mapped
    }

    /**
     * @param value Start IP Address.
     */
    @JvmName("lnmuhyfpaapekkic")
    public suspend fun startIP(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startIP = mapped
    }

    internal fun build(): QosIpRangeArgs = QosIpRangeArgs(
        endIP = endIP,
        startIP = startIP,
    )
}
