@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.RouteArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.RouteNextHopType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Route resource.
 * @property addressPrefix The destination CIDR to which the route applies.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property hasBgpOverride A value indicating whether this route overrides overlapping BGP routes regardless of LPM.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property nextHopIpAddress The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
 * @property nextHopType The type of Azure hop the packet should be sent to.
 * @property provisioningState The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
 * @property type The type of the resource.
 */
public data class RouteArgs(
    public val addressPrefix: Output<String>? = null,
    public val etag: Output<String>? = null,
    public val hasBgpOverride: Output<Boolean>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val nextHopIpAddress: Output<String>? = null,
    public val nextHopType: Output<Either<String, RouteNextHopType>>,
    public val provisioningState: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.RouteArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.RouteArgs =
        com.pulumi.azurenative.network.inputs.RouteArgs.builder()
            .addressPrefix(addressPrefix?.applyValue({ args0 -> args0 }))
            .etag(etag?.applyValue({ args0 -> args0 }))
            .hasBgpOverride(hasBgpOverride?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .nextHopIpAddress(nextHopIpAddress?.applyValue({ args0 -> args0 }))
            .nextHopType(
                nextHopType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteArgs].
 */
@PulumiTagMarker
public class RouteArgsBuilder internal constructor() {
    private var addressPrefix: Output<String>? = null

    private var etag: Output<String>? = null

    private var hasBgpOverride: Output<Boolean>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var nextHopIpAddress: Output<String>? = null

    private var nextHopType: Output<Either<String, RouteNextHopType>>? = null

    private var provisioningState: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The destination CIDR to which the route applies.
     */
    @JvmName("pfyrswqxixppowiq")
    public suspend fun addressPrefix(`value`: Output<String>) {
        this.addressPrefix = value
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("qxctsdmecdaoqtak")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value A value indicating whether this route overrides overlapping BGP routes regardless of LPM.
     */
    @JvmName("iasehwocwyyptdiw")
    public suspend fun hasBgpOverride(`value`: Output<Boolean>) {
        this.hasBgpOverride = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("xscoseqrvkqtkima")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("dlvnfyrevcdejbqr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
     */
    @JvmName("aumjaiixofbwmldg")
    public suspend fun nextHopIpAddress(`value`: Output<String>) {
        this.nextHopIpAddress = value
    }

    /**
     * @param value The type of Azure hop the packet should be sent to.
     */
    @JvmName("bagnvierhivrawlk")
    public suspend fun nextHopType(`value`: Output<Either<String, RouteNextHopType>>) {
        this.nextHopType = value
    }

    /**
     * @param value The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
     */
    @JvmName("anxlkqwckgolagex")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("hehtgtkixxmfnnwg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The destination CIDR to which the route applies.
     */
    @JvmName("mspmdnyvcudtmdur")
    public suspend fun addressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefix = mapped
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("ljgclyenocckkgbd")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value A value indicating whether this route overrides overlapping BGP routes regardless of LPM.
     */
    @JvmName("vjvwgqjtlttyiehp")
    public suspend fun hasBgpOverride(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hasBgpOverride = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("cynetwuosxgccvwc")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("frvxoskqnhoeawgj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
     */
    @JvmName("spborxcdtdtvmlqx")
    public suspend fun nextHopIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextHopIpAddress = mapped
    }

    /**
     * @param value The type of Azure hop the packet should be sent to.
     */
    @JvmName("aafabirwcncfyqbx")
    public suspend fun nextHopType(`value`: Either<String, RouteNextHopType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextHopType = mapped
    }

    /**
     * @param value The type of Azure hop the packet should be sent to.
     */
    @JvmName("bvwvjauxicdsudyn")
    public fun nextHopType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RouteNextHopType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextHopType = mapped
    }

    /**
     * @param value The type of Azure hop the packet should be sent to.
     */
    @JvmName("ygkbfhxkqthnjrof")
    public fun nextHopType(`value`: RouteNextHopType) {
        val toBeMapped = Either.ofRight<String, RouteNextHopType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextHopType = mapped
    }

    /**
     * @param value The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
     */
    @JvmName("wrodekpyagtnlucg")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("uxsthvhxrdfnqxaj")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RouteArgs = RouteArgs(
        addressPrefix = addressPrefix,
        etag = etag,
        hasBgpOverride = hasBgpOverride,
        id = id,
        name = name,
        nextHopIpAddress = nextHopIpAddress,
        nextHopType = nextHopType ?: throw PulumiNullFieldException("nextHopType"),
        provisioningState = provisioningState,
        type = type,
    )
}
