@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the Web Application Firewall policy for each routing rule (if applicable)
 * @property id Resource ID.
 */
public data class RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs(
    public val id: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs =
        com.pulumi.azurenative.network.inputs.RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs].
 */
@PulumiTagMarker
public class RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgsBuilder internal
constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("nbutvphsoojfamdv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("cvpdcrryewupmwgg")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs =
        RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs(
            id = id,
        )
}
