@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.SecurityRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.SecurityRuleAccess
import com.pulumi.azurenative.network.kotlin.enums.SecurityRuleDirection
import com.pulumi.azurenative.network.kotlin.enums.SecurityRuleProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network security rule.
 * @property access The network traffic is allowed or denied.
 * @property description A description for this rule. Restricted to 140 chars.
 * @property destinationAddressPrefix The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
 * @property destinationAddressPrefixes The destination address prefixes. CIDR or destination IP ranges.
 * @property destinationApplicationSecurityGroups The application security group specified as destination.
 * @property destinationPortRange The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
 * @property destinationPortRanges The destination port ranges.
 * @property direction The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property priority The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
 * @property protocol Network protocol this rule applies to.
 * @property provisioningState The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
 * @property sourceAddressPrefix The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
 * @property sourceAddressPrefixes The CIDR or source IP ranges.
 * @property sourceApplicationSecurityGroups The application security group specified as source.
 * @property sourcePortRange The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
 * @property sourcePortRanges The source port ranges.
 * @property type The type of the resource.
 */
public data class SecurityRuleArgs(
    public val access: Output<Either<String, SecurityRuleAccess>>,
    public val description: Output<String>? = null,
    public val destinationAddressPrefix: Output<String>? = null,
    public val destinationAddressPrefixes: Output<List<String>>? = null,
    public val destinationApplicationSecurityGroups: Output<List<ApplicationSecurityGroupArgs>>? =
        null,
    public val destinationPortRange: Output<String>? = null,
    public val destinationPortRanges: Output<List<String>>? = null,
    public val direction: Output<Either<String, SecurityRuleDirection>>,
    public val etag: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val protocol: Output<Either<String, SecurityRuleProtocol>>,
    public val provisioningState: Output<String>? = null,
    public val sourceAddressPrefix: Output<String>? = null,
    public val sourceAddressPrefixes: Output<List<String>>? = null,
    public val sourceApplicationSecurityGroups: Output<List<ApplicationSecurityGroupArgs>>? = null,
    public val sourcePortRange: Output<String>? = null,
    public val sourcePortRanges: Output<List<String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.SecurityRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.SecurityRuleArgs =
        com.pulumi.azurenative.network.inputs.SecurityRuleArgs.builder()
            .access(
                access.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationAddressPrefix(destinationAddressPrefix?.applyValue({ args0 -> args0 }))
            .destinationAddressPrefixes(
                destinationAddressPrefixes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .destinationApplicationSecurityGroups(
                destinationApplicationSecurityGroups?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .destinationPortRange(destinationPortRange?.applyValue({ args0 -> args0 }))
            .destinationPortRanges(destinationPortRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .direction(
                direction.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .etag(etag?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .sourceAddressPrefix(sourceAddressPrefix?.applyValue({ args0 -> args0 }))
            .sourceAddressPrefixes(sourceAddressPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceApplicationSecurityGroups(
                sourceApplicationSecurityGroups?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .sourcePortRange(sourcePortRange?.applyValue({ args0 -> args0 }))
            .sourcePortRanges(sourcePortRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityRuleArgs].
 */
@PulumiTagMarker
public class SecurityRuleArgsBuilder internal constructor() {
    private var access: Output<Either<String, SecurityRuleAccess>>? = null

    private var description: Output<String>? = null

    private var destinationAddressPrefix: Output<String>? = null

    private var destinationAddressPrefixes: Output<List<String>>? = null

    private var destinationApplicationSecurityGroups: Output<List<ApplicationSecurityGroupArgs>>? =
        null

    private var destinationPortRange: Output<String>? = null

    private var destinationPortRanges: Output<List<String>>? = null

    private var direction: Output<Either<String, SecurityRuleDirection>>? = null

    private var etag: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var protocol: Output<Either<String, SecurityRuleProtocol>>? = null

    private var provisioningState: Output<String>? = null

    private var sourceAddressPrefix: Output<String>? = null

    private var sourceAddressPrefixes: Output<List<String>>? = null

    private var sourceApplicationSecurityGroups: Output<List<ApplicationSecurityGroupArgs>>? = null

    private var sourcePortRange: Output<String>? = null

    private var sourcePortRanges: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The network traffic is allowed or denied.
     */
    @JvmName("wvrmilvmgdkodthp")
    public suspend fun access(`value`: Output<Either<String, SecurityRuleAccess>>) {
        this.access = value
    }

    /**
     * @param value A description for this rule. Restricted to 140 chars.
     */
    @JvmName("eioekeuumheeqhtp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
     */
    @JvmName("qxdiudpowtipyjkg")
    public suspend fun destinationAddressPrefix(`value`: Output<String>) {
        this.destinationAddressPrefix = value
    }

    /**
     * @param value The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("iyjcprvbdcmvnnbo")
    public suspend fun destinationAddressPrefixes(`value`: Output<List<String>>) {
        this.destinationAddressPrefixes = value
    }

    @JvmName("qxpvpvbhladadjlc")
    public suspend fun destinationAddressPrefixes(vararg values: Output<String>) {
        this.destinationAddressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("hdkfiljoujkekybe")
    public suspend fun destinationAddressPrefixes(values: List<Output<String>>) {
        this.destinationAddressPrefixes = Output.all(values)
    }

    /**
     * @param value The application security group specified as destination.
     */
    @JvmName("uekocgbqlywrftuv")
    public suspend
    fun destinationApplicationSecurityGroups(`value`: Output<List<ApplicationSecurityGroupArgs>>) {
        this.destinationApplicationSecurityGroups = value
    }

    @JvmName("ngwvoevjqnkdpbme")
    public suspend fun destinationApplicationSecurityGroups(
        vararg
        values: Output<ApplicationSecurityGroupArgs>,
    ) {
        this.destinationApplicationSecurityGroups = Output.all(values.asList())
    }

    /**
     * @param values The application security group specified as destination.
     */
    @JvmName("ucvehemluxvvjehb")
    public suspend
    fun destinationApplicationSecurityGroups(values: List<Output<ApplicationSecurityGroupArgs>>) {
        this.destinationApplicationSecurityGroups = Output.all(values)
    }

    /**
     * @param value The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    @JvmName("rjekpekljkkpbnlx")
    public suspend fun destinationPortRange(`value`: Output<String>) {
        this.destinationPortRange = value
    }

    /**
     * @param value The destination port ranges.
     */
    @JvmName("vmjnhyypwyqmkkie")
    public suspend fun destinationPortRanges(`value`: Output<List<String>>) {
        this.destinationPortRanges = value
    }

    @JvmName("fjiuagaqcpdthmwd")
    public suspend fun destinationPortRanges(vararg values: Output<String>) {
        this.destinationPortRanges = Output.all(values.asList())
    }

    /**
     * @param values The destination port ranges.
     */
    @JvmName("rlnuixvmtvgamodh")
    public suspend fun destinationPortRanges(values: List<Output<String>>) {
        this.destinationPortRanges = Output.all(values)
    }

    /**
     * @param value The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
     */
    @JvmName("jbwnwypuecvkoahy")
    public suspend fun direction(`value`: Output<Either<String, SecurityRuleDirection>>) {
        this.direction = value
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("seepnoyymkeihhsb")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("cqxjtgtvmpspifbu")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("qqfxrnmvhkaaiili")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
     */
    @JvmName("ageohvyshvmxwbbt")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("sfjgdoimaswimvwx")
    public suspend fun protocol(`value`: Output<Either<String, SecurityRuleProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
     */
    @JvmName("xwkyamitxcdbutui")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
     */
    @JvmName("igocuiwvxugetctk")
    public suspend fun sourceAddressPrefix(`value`: Output<String>) {
        this.sourceAddressPrefix = value
    }

    /**
     * @param value The CIDR or source IP ranges.
     */
    @JvmName("opshgrrdtcpjkuci")
    public suspend fun sourceAddressPrefixes(`value`: Output<List<String>>) {
        this.sourceAddressPrefixes = value
    }

    @JvmName("sgyrjdolioxbojef")
    public suspend fun sourceAddressPrefixes(vararg values: Output<String>) {
        this.sourceAddressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values The CIDR or source IP ranges.
     */
    @JvmName("hxwidlkpsauudsgb")
    public suspend fun sourceAddressPrefixes(values: List<Output<String>>) {
        this.sourceAddressPrefixes = Output.all(values)
    }

    /**
     * @param value The application security group specified as source.
     */
    @JvmName("yobvgntqacypjioq")
    public suspend
    fun sourceApplicationSecurityGroups(`value`: Output<List<ApplicationSecurityGroupArgs>>) {
        this.sourceApplicationSecurityGroups = value
    }

    @JvmName("gotourxopiskqvqs")
    public suspend fun sourceApplicationSecurityGroups(
        vararg
        values: Output<ApplicationSecurityGroupArgs>,
    ) {
        this.sourceApplicationSecurityGroups = Output.all(values.asList())
    }

    /**
     * @param values The application security group specified as source.
     */
    @JvmName("xedbagevlqgwxgpf")
    public suspend
    fun sourceApplicationSecurityGroups(values: List<Output<ApplicationSecurityGroupArgs>>) {
        this.sourceApplicationSecurityGroups = Output.all(values)
    }

    /**
     * @param value The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    @JvmName("ydipccbqbkvqwygs")
    public suspend fun sourcePortRange(`value`: Output<String>) {
        this.sourcePortRange = value
    }

    /**
     * @param value The source port ranges.
     */
    @JvmName("khkhydgditomtsnv")
    public suspend fun sourcePortRanges(`value`: Output<List<String>>) {
        this.sourcePortRanges = value
    }

    @JvmName("pbkbrxvnpcssqsgr")
    public suspend fun sourcePortRanges(vararg values: Output<String>) {
        this.sourcePortRanges = Output.all(values.asList())
    }

    /**
     * @param values The source port ranges.
     */
    @JvmName("mjyxipgjcjygsmag")
    public suspend fun sourcePortRanges(values: List<Output<String>>) {
        this.sourcePortRanges = Output.all(values)
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("ckkicdexjrrnitns")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The network traffic is allowed or denied.
     */
    @JvmName("dimseqmmbwjhcbly")
    public suspend fun access(`value`: Either<String, SecurityRuleAccess>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value The network traffic is allowed or denied.
     */
    @JvmName("clnifribvgfigqle")
    public fun access(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityRuleAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value The network traffic is allowed or denied.
     */
    @JvmName("hiekxsovwiykooce")
    public fun access(`value`: SecurityRuleAccess) {
        val toBeMapped = Either.ofRight<String, SecurityRuleAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value A description for this rule. Restricted to 140 chars.
     */
    @JvmName("desicedhqabtangq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
     */
    @JvmName("pgovdbehswmuvfyf")
    public suspend fun destinationAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddressPrefix = mapped
    }

    /**
     * @param value The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("ipkactnbqyrnwipe")
    public suspend fun destinationAddressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddressPrefixes = mapped
    }

    /**
     * @param values The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("wyxrcylrnggqtcvt")
    public suspend fun destinationAddressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationAddressPrefixes = mapped
    }

    /**
     * @param value The application security group specified as destination.
     */
    @JvmName("cuciemfxkrjorutk")
    public suspend
    fun destinationApplicationSecurityGroups(`value`: List<ApplicationSecurityGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as destination.
     */
    @JvmName("dqsflpxjiyodaurf")
    public suspend
    fun destinationApplicationSecurityGroups(argument: List<suspend ApplicationSecurityGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as destination.
     */
    @JvmName("gjhatiedjpuklmsw")
    public suspend fun destinationApplicationSecurityGroups(
        vararg
        argument: suspend ApplicationSecurityGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as destination.
     */
    @JvmName("smerhckuqwkjqedn")
    public suspend
    fun destinationApplicationSecurityGroups(argument: suspend ApplicationSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.destinationApplicationSecurityGroups = mapped
    }

    /**
     * @param values The application security group specified as destination.
     */
    @JvmName("ytnqqhlywdfisnnu")
    public suspend fun destinationApplicationSecurityGroups(
        vararg
        values: ApplicationSecurityGroupArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationApplicationSecurityGroups = mapped
    }

    /**
     * @param value The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    @JvmName("pnsopxbomvgjmvxc")
    public suspend fun destinationPortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRange = mapped
    }

    /**
     * @param value The destination port ranges.
     */
    @JvmName("ilyumglstwbiydbm")
    public suspend fun destinationPortRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param values The destination port ranges.
     */
    @JvmName("fjxviwknvmcyniir")
    public suspend fun destinationPortRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param value The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
     */
    @JvmName("ldikgfaahcehhxlj")
    public suspend fun direction(`value`: Either<String, SecurityRuleDirection>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
     */
    @JvmName("nnrwavvgiiwtdtvv")
    public fun direction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityRuleDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
     */
    @JvmName("tmdgkvfjkbwnkjlq")
    public fun direction(`value`: SecurityRuleDirection) {
        val toBeMapped = Either.ofRight<String, SecurityRuleDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("jcjafeafpdxlvdmk")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("mbtqdwwhmlowqndb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("fefryyptjisqkgco")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
     */
    @JvmName("rdismmeuxvtdtehl")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("mxyajtrdpdwxdtdc")
    public suspend fun protocol(`value`: Either<String, SecurityRuleProtocol>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("oxnmduxijbmanvuy")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityRuleProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("qjxbadwarimhhrra")
    public fun protocol(`value`: SecurityRuleProtocol) {
        val toBeMapped = Either.ofRight<String, SecurityRuleProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
     */
    @JvmName("bligfwupavspbiba")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
     */
    @JvmName("lcsuxhbscmmbdeop")
    public suspend fun sourceAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddressPrefix = mapped
    }

    /**
     * @param value The CIDR or source IP ranges.
     */
    @JvmName("vhfeacafrqdthrxc")
    public suspend fun sourceAddressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddressPrefixes = mapped
    }

    /**
     * @param values The CIDR or source IP ranges.
     */
    @JvmName("cjvbyqmpjvmgdlag")
    public suspend fun sourceAddressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddressPrefixes = mapped
    }

    /**
     * @param value The application security group specified as source.
     */
    @JvmName("amslmajdvajhslmv")
    public suspend fun sourceApplicationSecurityGroups(`value`: List<ApplicationSecurityGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as source.
     */
    @JvmName("xpcfpokwryrirnne")
    public suspend
    fun sourceApplicationSecurityGroups(argument: List<suspend ApplicationSecurityGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as source.
     */
    @JvmName("ffowvbeaiuqwojcg")
    public suspend fun sourceApplicationSecurityGroups(
        vararg
        argument: suspend ApplicationSecurityGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as source.
     */
    @JvmName("hbmkvrgjidiwjhrc")
    public suspend
    fun sourceApplicationSecurityGroups(argument: suspend ApplicationSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sourceApplicationSecurityGroups = mapped
    }

    /**
     * @param values The application security group specified as source.
     */
    @JvmName("iuwaghvppglwetko")
    public suspend fun sourceApplicationSecurityGroups(vararg values: ApplicationSecurityGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceApplicationSecurityGroups = mapped
    }

    /**
     * @param value The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    @JvmName("cywydadhlogiuefa")
    public suspend fun sourcePortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRange = mapped
    }

    /**
     * @param value The source port ranges.
     */
    @JvmName("fimlbfdtifcqxovd")
    public suspend fun sourcePortRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param values The source port ranges.
     */
    @JvmName("qhetthuinyypfccn")
    public suspend fun sourcePortRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("herwudxnmaufsepi")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SecurityRuleArgs = SecurityRuleArgs(
        access = access ?: throw PulumiNullFieldException("access"),
        description = description,
        destinationAddressPrefix = destinationAddressPrefix,
        destinationAddressPrefixes = destinationAddressPrefixes,
        destinationApplicationSecurityGroups = destinationApplicationSecurityGroups,
        destinationPortRange = destinationPortRange,
        destinationPortRanges = destinationPortRanges,
        direction = direction ?: throw PulumiNullFieldException("direction"),
        etag = etag,
        id = id,
        name = name,
        priority = priority,
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
        provisioningState = provisioningState,
        sourceAddressPrefix = sourceAddressPrefix,
        sourceAddressPrefixes = sourceAddressPrefixes,
        sourceApplicationSecurityGroups = sourceApplicationSecurityGroups,
        sourcePortRange = sourcePortRange,
        sourcePortRanges = sourcePortRanges,
        type = type,
    )
}
