@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.SoaRecordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An SOA record.
 * @property email The email contact for this SOA record.
 * @property expireTime The expire time for this SOA record.
 * @property host The domain name of the authoritative name server for this SOA record.
 * @property minimumTtl The minimum value for this SOA record. By convention this is used to determine the negative caching duration.
 * @property refreshTime The refresh value for this SOA record.
 * @property retryTime The retry time for this SOA record.
 * @property serialNumber The serial number for this SOA record.
 */
public data class SoaRecordArgs(
    public val email: Output<String>? = null,
    public val expireTime: Output<Double>? = null,
    public val host: Output<String>? = null,
    public val minimumTtl: Output<Double>? = null,
    public val refreshTime: Output<Double>? = null,
    public val retryTime: Output<Double>? = null,
    public val serialNumber: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.SoaRecordArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.SoaRecordArgs =
        com.pulumi.azurenative.network.inputs.SoaRecordArgs.builder()
            .email(email?.applyValue({ args0 -> args0 }))
            .expireTime(expireTime?.applyValue({ args0 -> args0 }))
            .host(host?.applyValue({ args0 -> args0 }))
            .minimumTtl(minimumTtl?.applyValue({ args0 -> args0 }))
            .refreshTime(refreshTime?.applyValue({ args0 -> args0 }))
            .retryTime(retryTime?.applyValue({ args0 -> args0 }))
            .serialNumber(serialNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SoaRecordArgs].
 */
@PulumiTagMarker
public class SoaRecordArgsBuilder internal constructor() {
    private var email: Output<String>? = null

    private var expireTime: Output<Double>? = null

    private var host: Output<String>? = null

    private var minimumTtl: Output<Double>? = null

    private var refreshTime: Output<Double>? = null

    private var retryTime: Output<Double>? = null

    private var serialNumber: Output<Double>? = null

    /**
     * @param value The email contact for this SOA record.
     */
    @JvmName("vvojrrpxxptgnuhh")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value The expire time for this SOA record.
     */
    @JvmName("yskwwwinlwssxttt")
    public suspend fun expireTime(`value`: Output<Double>) {
        this.expireTime = value
    }

    /**
     * @param value The domain name of the authoritative name server for this SOA record.
     */
    @JvmName("wgftdxcqckyxawve")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value The minimum value for this SOA record. By convention this is used to determine the negative caching duration.
     */
    @JvmName("egfnnxtxtkdbsaii")
    public suspend fun minimumTtl(`value`: Output<Double>) {
        this.minimumTtl = value
    }

    /**
     * @param value The refresh value for this SOA record.
     */
    @JvmName("xlsmrdjhpposaxdp")
    public suspend fun refreshTime(`value`: Output<Double>) {
        this.refreshTime = value
    }

    /**
     * @param value The retry time for this SOA record.
     */
    @JvmName("qdhsbpfygdipxwsr")
    public suspend fun retryTime(`value`: Output<Double>) {
        this.retryTime = value
    }

    /**
     * @param value The serial number for this SOA record.
     */
    @JvmName("kdxdclsfixkgueop")
    public suspend fun serialNumber(`value`: Output<Double>) {
        this.serialNumber = value
    }

    /**
     * @param value The email contact for this SOA record.
     */
    @JvmName("epuxfgnsugjglfnq")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value The expire time for this SOA record.
     */
    @JvmName("laptxvuscwkfyvua")
    public suspend fun expireTime(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expireTime = mapped
    }

    /**
     * @param value The domain name of the authoritative name server for this SOA record.
     */
    @JvmName("rfbdaqiprqudjpcn")
    public suspend fun host(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value The minimum value for this SOA record. By convention this is used to determine the negative caching duration.
     */
    @JvmName("gglymrjxaqxwpksy")
    public suspend fun minimumTtl(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumTtl = mapped
    }

    /**
     * @param value The refresh value for this SOA record.
     */
    @JvmName("asrmadkkbyiheckt")
    public suspend fun refreshTime(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshTime = mapped
    }

    /**
     * @param value The retry time for this SOA record.
     */
    @JvmName("jdblqeajrdubktrq")
    public suspend fun retryTime(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryTime = mapped
    }

    /**
     * @param value The serial number for this SOA record.
     */
    @JvmName("twunspqkilettgxm")
    public suspend fun serialNumber(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serialNumber = mapped
    }

    internal fun build(): SoaRecordArgs = SoaRecordArgs(
        email = email,
        expireTime = expireTime,
        host = host,
        minimumTtl = minimumTtl,
        refreshTime = refreshTime,
        retryTime = retryTime,
        serialNumber = serialNumber,
    )
}
