@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.SrvRecordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An SRV record.
 * @property port The port value for this SRV record.
 * @property priority The priority value for this SRV record.
 * @property target The target domain name for this SRV record.
 * @property weight The weight value for this SRV record.
 */
public data class SrvRecordArgs(
    public val port: Output<Int>? = null,
    public val priority: Output<Int>? = null,
    public val target: Output<String>? = null,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.SrvRecordArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.SrvRecordArgs =
        com.pulumi.azurenative.network.inputs.SrvRecordArgs.builder()
            .port(port?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SrvRecordArgs].
 */
@PulumiTagMarker
public class SrvRecordArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var priority: Output<Int>? = null

    private var target: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The port value for this SRV record.
     */
    @JvmName("wiknjoilyspuyooo")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The priority value for this SRV record.
     */
    @JvmName("yvwrapjqkhbetaoi")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The target domain name for this SRV record.
     */
    @JvmName("iacnxhrdmbokupdd")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value The weight value for this SRV record.
     */
    @JvmName("pvqoqjnqstljtkpv")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The port value for this SRV record.
     */
    @JvmName("nwgsalvsvwxmevjy")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The priority value for this SRV record.
     */
    @JvmName("brvxyqgwwprguhaq")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The target domain name for this SRV record.
     */
    @JvmName("tuosojwmmsqgugxu")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value The weight value for this SRV record.
     */
    @JvmName("lsqtmubmmfdebwuy")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): SrvRecordArgs = SrvRecordArgs(
        port = port,
        priority = priority,
        target = target,
        weight = weight,
    )
}
