@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.TrafficSelectorPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An traffic selector policy for a virtual network gateway connection.
 * @property localAddressRanges A collection of local address spaces in CIDR format.
 * @property remoteAddressRanges A collection of remote address spaces in CIDR format.
 */
public data class TrafficSelectorPolicyArgs(
    public val localAddressRanges: Output<List<String>>,
    public val remoteAddressRanges: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.TrafficSelectorPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.TrafficSelectorPolicyArgs =
        com.pulumi.azurenative.network.inputs.TrafficSelectorPolicyArgs.builder()
            .localAddressRanges(localAddressRanges.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .remoteAddressRanges(
                remoteAddressRanges.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [TrafficSelectorPolicyArgs].
 */
@PulumiTagMarker
public class TrafficSelectorPolicyArgsBuilder internal constructor() {
    private var localAddressRanges: Output<List<String>>? = null

    private var remoteAddressRanges: Output<List<String>>? = null

    /**
     * @param value A collection of local address spaces in CIDR format.
     */
    @JvmName("aeytpwcokocggvis")
    public suspend fun localAddressRanges(`value`: Output<List<String>>) {
        this.localAddressRanges = value
    }

    @JvmName("kxqugsxunmcmbfwh")
    public suspend fun localAddressRanges(vararg values: Output<String>) {
        this.localAddressRanges = Output.all(values.asList())
    }

    /**
     * @param values A collection of local address spaces in CIDR format.
     */
    @JvmName("yyponsmftbtvmodg")
    public suspend fun localAddressRanges(values: List<Output<String>>) {
        this.localAddressRanges = Output.all(values)
    }

    /**
     * @param value A collection of remote address spaces in CIDR format.
     */
    @JvmName("shkmsiivnpxvpens")
    public suspend fun remoteAddressRanges(`value`: Output<List<String>>) {
        this.remoteAddressRanges = value
    }

    @JvmName("fefvwjlcmqouqmcs")
    public suspend fun remoteAddressRanges(vararg values: Output<String>) {
        this.remoteAddressRanges = Output.all(values.asList())
    }

    /**
     * @param values A collection of remote address spaces in CIDR format.
     */
    @JvmName("njskrudrqskcbjdc")
    public suspend fun remoteAddressRanges(values: List<Output<String>>) {
        this.remoteAddressRanges = Output.all(values)
    }

    /**
     * @param value A collection of local address spaces in CIDR format.
     */
    @JvmName("wiipuoceugxtkonr")
    public suspend fun localAddressRanges(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localAddressRanges = mapped
    }

    /**
     * @param values A collection of local address spaces in CIDR format.
     */
    @JvmName("agrhhelfaxxwltrg")
    public suspend fun localAddressRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localAddressRanges = mapped
    }

    /**
     * @param value A collection of remote address spaces in CIDR format.
     */
    @JvmName("flqrrjlaivpqsotu")
    public suspend fun remoteAddressRanges(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.remoteAddressRanges = mapped
    }

    /**
     * @param values A collection of remote address spaces in CIDR format.
     */
    @JvmName("enapxrhpofimvprk")
    public suspend fun remoteAddressRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.remoteAddressRanges = mapped
    }

    internal fun build(): TrafficSelectorPolicyArgs = TrafficSelectorPolicyArgs(
        localAddressRanges = localAddressRanges ?: throw PulumiNullFieldException("localAddressRanges"),
        remoteAddressRanges = remoteAddressRanges ?: throw PulumiNullFieldException("remoteAddressRanges"),
    )
}
