@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.TxtRecordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A TXT record.
 * @property value The text value of this TXT record.
 */
public data class TxtRecordArgs(
    public val `value`: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.TxtRecordArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.TxtRecordArgs =
        com.pulumi.azurenative.network.inputs.TxtRecordArgs.builder()
            .`value`(`value`?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [TxtRecordArgs].
 */
@PulumiTagMarker
public class TxtRecordArgsBuilder internal constructor() {
    private var `value`: Output<List<String>>? = null

    /**
     * @param value The text value of this TXT record.
     */
    @JvmName("axehyxuvfnlbajoa")
    public suspend fun `value`(`value`: Output<List<String>>) {
        this.`value` = value
    }

    @JvmName("kbibiogochegftwb")
    public suspend fun `value`(vararg values: Output<String>) {
        this.`value` = Output.all(values.asList())
    }

    /**
     * @param values The text value of this TXT record.
     */
    @JvmName("upotehjuduckabnq")
    public suspend fun `value`(values: List<Output<String>>) {
        this.`value` = Output.all(values)
    }

    /**
     * @param value The text value of this TXT record.
     */
    @JvmName("drwlsfjymjqcrpki")
    public suspend fun `value`(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param values The text value of this TXT record.
     */
    @JvmName("bdaamkucmgsxcshi")
    public suspend fun `value`(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TxtRecordArgs = TxtRecordArgs(
        `value` = `value`,
    )
}
