@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualHubRouteTableV2Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VirtualHubRouteTableV2 Resource.
 * @property attachedConnections List of all connections attached to this route table v2.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property routes List of all routes.
 */
public data class VirtualHubRouteTableV2Args(
    public val attachedConnections: Output<List<String>>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val routes: Output<List<VirtualHubRouteV2Args>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualHubRouteTableV2Args> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VirtualHubRouteTableV2Args =
        com.pulumi.azurenative.network.inputs.VirtualHubRouteTableV2Args.builder()
            .attachedConnections(attachedConnections?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .routes(
                routes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualHubRouteTableV2Args].
 */
@PulumiTagMarker
public class VirtualHubRouteTableV2ArgsBuilder internal constructor() {
    private var attachedConnections: Output<List<String>>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var routes: Output<List<VirtualHubRouteV2Args>>? = null

    /**
     * @param value List of all connections attached to this route table v2.
     */
    @JvmName("aofcrmjkkvdjrlyl")
    public suspend fun attachedConnections(`value`: Output<List<String>>) {
        this.attachedConnections = value
    }

    @JvmName("nmbwyjkxldtbemkl")
    public suspend fun attachedConnections(vararg values: Output<String>) {
        this.attachedConnections = Output.all(values.asList())
    }

    /**
     * @param values List of all connections attached to this route table v2.
     */
    @JvmName("coacjtexxldrydut")
    public suspend fun attachedConnections(values: List<Output<String>>) {
        this.attachedConnections = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("pdceqstlmfqheoap")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("kibbtrwrlqxbwfpo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of all routes.
     */
    @JvmName("quhvwiwnvrhdosyu")
    public suspend fun routes(`value`: Output<List<VirtualHubRouteV2Args>>) {
        this.routes = value
    }

    @JvmName("hjrfgwymdxgwqaje")
    public suspend fun routes(vararg values: Output<VirtualHubRouteV2Args>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values List of all routes.
     */
    @JvmName("kfybqrukngsawdrn")
    public suspend fun routes(values: List<Output<VirtualHubRouteV2Args>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value List of all connections attached to this route table v2.
     */
    @JvmName("gqwurlqwtypwjkov")
    public suspend fun attachedConnections(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachedConnections = mapped
    }

    /**
     * @param values List of all connections attached to this route table v2.
     */
    @JvmName("ylpjfxegovdexouj")
    public suspend fun attachedConnections(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attachedConnections = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("gfpkbvttqlfxypxb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("risqwactniyxapya")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of all routes.
     */
    @JvmName("tcnxeimsygsqijpv")
    public suspend fun routes(`value`: List<VirtualHubRouteV2Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument List of all routes.
     */
    @JvmName("ymksogrffgkkfhtn")
    public suspend fun routes(argument: List<suspend VirtualHubRouteV2ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualHubRouteV2ArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument List of all routes.
     */
    @JvmName("mksefuandyckjhju")
    public suspend fun routes(vararg argument: suspend VirtualHubRouteV2ArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualHubRouteV2ArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument List of all routes.
     */
    @JvmName("nmoqwfplodluwtff")
    public suspend fun routes(argument: suspend VirtualHubRouteV2ArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualHubRouteV2ArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values List of all routes.
     */
    @JvmName("vnejbqysppwxoywk")
    public suspend fun routes(vararg values: VirtualHubRouteV2Args) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    internal fun build(): VirtualHubRouteTableV2Args = VirtualHubRouteTableV2Args(
        attachedConnections = attachedConnections,
        id = id,
        name = name,
        routes = routes,
    )
}
