@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayIPConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.IPAllocationMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * IP configuration for virtual network gateway.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property privateIPAllocationMethod The private IP address allocation method.
 * @property publicIPAddress The reference to the public IP resource.
 * @property subnet The reference to the subnet resource.
 */
public data class VirtualNetworkGatewayIPConfigurationArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val privateIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null,
    public val publicIPAddress: Output<SubResourceArgs>? = null,
    public val subnet: Output<SubResourceArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayIPConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayIPConfigurationArgs =
        com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayIPConfigurationArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .privateIPAllocationMethod(
                privateIPAllocationMethod?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicIPAddress(publicIPAddress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNetworkGatewayIPConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualNetworkGatewayIPConfigurationArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var privateIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null

    private var publicIPAddress: Output<SubResourceArgs>? = null

    private var subnet: Output<SubResourceArgs>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("pahlxmwliqoiqdhj")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("gglxtfxxcaknnixb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("uqavdprqjmcpxctg")
    public suspend
    fun privateIPAllocationMethod(`value`: Output<Either<String, IPAllocationMethod>>) {
        this.privateIPAllocationMethod = value
    }

    /**
     * @param value The reference to the public IP resource.
     */
    @JvmName("iybdfckyitwxxnym")
    public suspend fun publicIPAddress(`value`: Output<SubResourceArgs>) {
        this.publicIPAddress = value
    }

    /**
     * @param value The reference to the subnet resource.
     */
    @JvmName("tmwyyavvicuthpkw")
    public suspend fun subnet(`value`: Output<SubResourceArgs>) {
        this.subnet = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("iyikwygmjjncgoyr")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("msguxtjvrucqgelm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("sjfpnqcwnqnetpmk")
    public suspend fun privateIPAllocationMethod(`value`: Either<String, IPAllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("phogjqwejurhdkpj")
    public fun privateIPAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("mswfrmbfctivrcmt")
    public fun privateIPAllocationMethod(`value`: IPAllocationMethod) {
        val toBeMapped = Either.ofRight<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The reference to the public IP resource.
     */
    @JvmName("bwomuepualjfuana")
    public suspend fun publicIPAddress(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAddress = mapped
    }

    /**
     * @param argument The reference to the public IP resource.
     */
    @JvmName("etybpdoprubvnqqj")
    public suspend fun publicIPAddress(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicIPAddress = mapped
    }

    /**
     * @param value The reference to the subnet resource.
     */
    @JvmName("hxmuoylqtdabexxs")
    public suspend fun subnet(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument The reference to the subnet resource.
     */
    @JvmName("mnmopcuokhrjqjee")
    public suspend fun subnet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): VirtualNetworkGatewayIPConfigurationArgs =
        VirtualNetworkGatewayIPConfigurationArgs(
            id = id,
            name = name,
            privateIPAllocationMethod = privateIPAllocationMethod,
            publicIPAddress = publicIPAddress,
            subnet = subnet,
        )
}
