@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.WebApplicationFirewallCustomRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayFirewallRateLimitDuration
import com.pulumi.azurenative.network.kotlin.enums.WebApplicationFirewallAction
import com.pulumi.azurenative.network.kotlin.enums.WebApplicationFirewallRuleType
import com.pulumi.azurenative.network.kotlin.enums.WebApplicationFirewallState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines contents of a web application rule.
 * @property action Type of Actions.
 * @property groupByUserSession List of user session identifier group by clauses.
 * @property matchConditions List of match conditions.
 * @property name The name of the resource that is unique within a policy. This name can be used to access the resource.
 * @property priority Priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
 * @property rateLimitDuration Duration over which Rate Limit policy will be applied. Applies only when ruleType is RateLimitRule.
 * @property rateLimitThreshold Rate Limit threshold to apply in case ruleType is RateLimitRule. Must be greater than or equal to 1
 * @property ruleType The rule type.
 * @property state Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
 */
public data class WebApplicationFirewallCustomRuleArgs(
    public val action: Output<Either<String, WebApplicationFirewallAction>>,
    public val groupByUserSession: Output<List<GroupByUserSessionArgs>>? = null,
    public val matchConditions: Output<List<MatchConditionArgs>>,
    public val name: Output<String>? = null,
    public val priority: Output<Int>,
    public val rateLimitDuration: Output<Either<String, ApplicationGatewayFirewallRateLimitDuration>>? =
        null,
    public val rateLimitThreshold: Output<Int>? = null,
    public val ruleType: Output<Either<String, WebApplicationFirewallRuleType>>,
    public val state: Output<Either<String, WebApplicationFirewallState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.WebApplicationFirewallCustomRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.WebApplicationFirewallCustomRuleArgs =
        com.pulumi.azurenative.network.inputs.WebApplicationFirewallCustomRuleArgs.builder()
            .action(
                action.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .groupByUserSession(
                groupByUserSession?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .matchConditions(
                matchConditions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority.applyValue({ args0 -> args0 }))
            .rateLimitDuration(
                rateLimitDuration?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .rateLimitThreshold(rateLimitThreshold?.applyValue({ args0 -> args0 }))
            .ruleType(
                ruleType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebApplicationFirewallCustomRuleArgs].
 */
@PulumiTagMarker
public class WebApplicationFirewallCustomRuleArgsBuilder internal constructor() {
    private var action: Output<Either<String, WebApplicationFirewallAction>>? = null

    private var groupByUserSession: Output<List<GroupByUserSessionArgs>>? = null

    private var matchConditions: Output<List<MatchConditionArgs>>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var rateLimitDuration:
        Output<Either<String, ApplicationGatewayFirewallRateLimitDuration>>? = null

    private var rateLimitThreshold: Output<Int>? = null

    private var ruleType: Output<Either<String, WebApplicationFirewallRuleType>>? = null

    private var state: Output<Either<String, WebApplicationFirewallState>>? = null

    /**
     * @param value Type of Actions.
     */
    @JvmName("adkudpblvqtaipsa")
    public suspend fun action(`value`: Output<Either<String, WebApplicationFirewallAction>>) {
        this.action = value
    }

    /**
     * @param value List of user session identifier group by clauses.
     */
    @JvmName("bjalilqpxlgodnil")
    public suspend fun groupByUserSession(`value`: Output<List<GroupByUserSessionArgs>>) {
        this.groupByUserSession = value
    }

    @JvmName("kndhejewecrkxytb")
    public suspend fun groupByUserSession(vararg values: Output<GroupByUserSessionArgs>) {
        this.groupByUserSession = Output.all(values.asList())
    }

    /**
     * @param values List of user session identifier group by clauses.
     */
    @JvmName("lfnlxnnxtipqukfw")
    public suspend fun groupByUserSession(values: List<Output<GroupByUserSessionArgs>>) {
        this.groupByUserSession = Output.all(values)
    }

    /**
     * @param value List of match conditions.
     */
    @JvmName("ruvuwbkuogrhckgb")
    public suspend fun matchConditions(`value`: Output<List<MatchConditionArgs>>) {
        this.matchConditions = value
    }

    @JvmName("qpvmibjsecnoxjlp")
    public suspend fun matchConditions(vararg values: Output<MatchConditionArgs>) {
        this.matchConditions = Output.all(values.asList())
    }

    /**
     * @param values List of match conditions.
     */
    @JvmName("qvnxpmvsjidakinx")
    public suspend fun matchConditions(values: List<Output<MatchConditionArgs>>) {
        this.matchConditions = Output.all(values)
    }

    /**
     * @param value The name of the resource that is unique within a policy. This name can be used to access the resource.
     */
    @JvmName("fvemxlyylatqtxjn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
     */
    @JvmName("ehgdnhwjteglbfoq")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Duration over which Rate Limit policy will be applied. Applies only when ruleType is RateLimitRule.
     */
    @JvmName("tyypqejmdkqdfflh")
    public suspend
    fun rateLimitDuration(`value`: Output<Either<String, ApplicationGatewayFirewallRateLimitDuration>>) {
        this.rateLimitDuration = value
    }

    /**
     * @param value Rate Limit threshold to apply in case ruleType is RateLimitRule. Must be greater than or equal to 1
     */
    @JvmName("kcgesnimmnfbkfff")
    public suspend fun rateLimitThreshold(`value`: Output<Int>) {
        this.rateLimitThreshold = value
    }

    /**
     * @param value The rule type.
     */
    @JvmName("xgjfcdaflrquaoye")
    public suspend fun ruleType(`value`: Output<Either<String, WebApplicationFirewallRuleType>>) {
        this.ruleType = value
    }

    /**
     * @param value Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("llposgnatpydvelw")
    public suspend fun state(`value`: Output<Either<String, WebApplicationFirewallState>>) {
        this.state = value
    }

    /**
     * @param value Type of Actions.
     */
    @JvmName("nmpxxfdgpyleakoa")
    public suspend fun action(`value`: Either<String, WebApplicationFirewallAction>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Type of Actions.
     */
    @JvmName("syocfwqpqunwxhuu")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WebApplicationFirewallAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Type of Actions.
     */
    @JvmName("jlfmtsdnydvyxygx")
    public fun action(`value`: WebApplicationFirewallAction) {
        val toBeMapped = Either.ofRight<String, WebApplicationFirewallAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value List of user session identifier group by clauses.
     */
    @JvmName("wnaiiwjwrrtgfhxt")
    public suspend fun groupByUserSession(`value`: List<GroupByUserSessionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupByUserSession = mapped
    }

    /**
     * @param argument List of user session identifier group by clauses.
     */
    @JvmName("vjvqtfvencqtdrno")
    public suspend
    fun groupByUserSession(argument: List<suspend GroupByUserSessionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GroupByUserSessionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.groupByUserSession = mapped
    }

    /**
     * @param argument List of user session identifier group by clauses.
     */
    @JvmName("ubisqcaphywxyway")
    public suspend fun groupByUserSession(
        vararg
        argument: suspend GroupByUserSessionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GroupByUserSessionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.groupByUserSession = mapped
    }

    /**
     * @param argument List of user session identifier group by clauses.
     */
    @JvmName("xnnmmxbspwqpsowl")
    public suspend
    fun groupByUserSession(argument: suspend GroupByUserSessionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GroupByUserSessionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.groupByUserSession = mapped
    }

    /**
     * @param values List of user session identifier group by clauses.
     */
    @JvmName("uapdflsyfaiaocfi")
    public suspend fun groupByUserSession(vararg values: GroupByUserSessionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupByUserSession = mapped
    }

    /**
     * @param value List of match conditions.
     */
    @JvmName("kaeywkcfqwjexlvv")
    public suspend fun matchConditions(`value`: List<MatchConditionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchConditions = mapped
    }

    /**
     * @param argument List of match conditions.
     */
    @JvmName("yjnsdvdxrrtcgeke")
    public suspend fun matchConditions(argument: List<suspend MatchConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MatchConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param argument List of match conditions.
     */
    @JvmName("twfgwhosxpgoujcf")
    public suspend fun matchConditions(
        vararg
        argument: suspend MatchConditionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MatchConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param argument List of match conditions.
     */
    @JvmName("utfaqutspkehuhnd")
    public suspend fun matchConditions(argument: suspend MatchConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MatchConditionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param values List of match conditions.
     */
    @JvmName("mojyvohbmysxvmal")
    public suspend fun matchConditions(vararg values: MatchConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchConditions = mapped
    }

    /**
     * @param value The name of the resource that is unique within a policy. This name can be used to access the resource.
     */
    @JvmName("ybqbeiydthmvqrla")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
     */
    @JvmName("lhaqsdicujkwviiq")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Duration over which Rate Limit policy will be applied. Applies only when ruleType is RateLimitRule.
     */
    @JvmName("yawkjrualjqejqrv")
    public suspend
    fun rateLimitDuration(`value`: Either<String, ApplicationGatewayFirewallRateLimitDuration>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateLimitDuration = mapped
    }

    /**
     * @param value Duration over which Rate Limit policy will be applied. Applies only when ruleType is RateLimitRule.
     */
    @JvmName("vklqsxisvdfvxnlq")
    public fun rateLimitDuration(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayFirewallRateLimitDuration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rateLimitDuration = mapped
    }

    /**
     * @param value Duration over which Rate Limit policy will be applied. Applies only when ruleType is RateLimitRule.
     */
    @JvmName("mgehucxkyoyaywbf")
    public fun rateLimitDuration(`value`: ApplicationGatewayFirewallRateLimitDuration) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayFirewallRateLimitDuration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rateLimitDuration = mapped
    }

    /**
     * @param value Rate Limit threshold to apply in case ruleType is RateLimitRule. Must be greater than or equal to 1
     */
    @JvmName("ntirwmcgypjarcbv")
    public suspend fun rateLimitThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateLimitThreshold = mapped
    }

    /**
     * @param value The rule type.
     */
    @JvmName("yxroqxgsuyqltpja")
    public suspend fun ruleType(`value`: Either<String, WebApplicationFirewallRuleType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value The rule type.
     */
    @JvmName("imamwneqaoqyjyqq")
    public fun ruleType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WebApplicationFirewallRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value The rule type.
     */
    @JvmName("qkgxomihphyqmqdi")
    public fun ruleType(`value`: WebApplicationFirewallRuleType) {
        val toBeMapped = Either.ofRight<String, WebApplicationFirewallRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("ohaxlqubvwdieucv")
    public suspend fun state(`value`: Either<String, WebApplicationFirewallState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("ksrkylkxqjjqlsrm")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WebApplicationFirewallState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("ifqpjojejqblkffj")
    public fun state(`value`: WebApplicationFirewallState) {
        val toBeMapped = Either.ofRight<String, WebApplicationFirewallState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): WebApplicationFirewallCustomRuleArgs = WebApplicationFirewallCustomRuleArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        groupByUserSession = groupByUserSession,
        matchConditions = matchConditions ?: throw PulumiNullFieldException("matchConditions"),
        name = name,
        priority = priority ?: throw PulumiNullFieldException("priority"),
        rateLimitDuration = rateLimitDuration,
        rateLimitThreshold = rateLimitThreshold,
        ruleType = ruleType ?: throw PulumiNullFieldException("ruleType"),
        state = state,
    )
}
