@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Application gateway backendhealth http settings.
 * @property address IP address or FQDN of backend server.
 * @property health Health of backend server.
 * @property healthProbeLog Health Probe Log.
 * @property ipConfiguration Reference to IP configuration of backend server.
 */
public data class ApplicationGatewayBackendHealthServerResponse(
    public val address: String? = null,
    public val health: String? = null,
    public val healthProbeLog: String? = null,
    public val ipConfiguration: NetworkInterfaceIPConfigurationResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayBackendHealthServerResponse):
            ApplicationGatewayBackendHealthServerResponse =
            ApplicationGatewayBackendHealthServerResponse(
                address = javaType.address().map({ args0 -> args0 }).orElse(null),
                health = javaType.health().map({ args0 -> args0 }).orElse(null),
                healthProbeLog = javaType.healthProbeLog().map({ args0 -> args0 }).orElse(null),
                ipConfiguration = javaType.ipConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceIPConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
