@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Backend address pool settings of an application gateway.
 * @property affinityCookieName Cookie name to use for the affinity cookie.
 * @property authenticationCertificates Array of references to application gateway authentication certificates.
 * @property connectionDraining Connection draining of the backend http settings resource.
 * @property cookieBasedAffinity Cookie based affinity.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property hostName Host header to be sent to the backend servers.
 * @property id Resource ID.
 * @property name Name of the backend http settings that is unique within an Application Gateway.
 * @property path Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null.
 * @property pickHostNameFromBackendAddress Whether to pick host header should be picked from the host name of the backend server. Default value is false.
 * @property port The destination port on the backend.
 * @property probe Probe resource of an application gateway.
 * @property probeEnabled Whether the probe is enabled. Default value is false.
 * @property protocol The protocol used to communicate with the backend.
 * @property provisioningState The provisioning state of the backend HTTP settings resource.
 * @property requestTimeout Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds.
 * @property trustedRootCertificates Array of references to application gateway trusted root certificates.
 * @property type Type of the resource.
 */
public data class ApplicationGatewayBackendHttpSettingsResponse(
    public val affinityCookieName: String? = null,
    public val authenticationCertificates: List<SubResourceResponse>? = null,
    public val connectionDraining: ApplicationGatewayConnectionDrainingResponse? = null,
    public val cookieBasedAffinity: String? = null,
    public val etag: String,
    public val hostName: String? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val path: String? = null,
    public val pickHostNameFromBackendAddress: Boolean? = null,
    public val port: Int? = null,
    public val probe: SubResourceResponse? = null,
    public val probeEnabled: Boolean? = null,
    public val protocol: String? = null,
    public val provisioningState: String,
    public val requestTimeout: Int? = null,
    public val trustedRootCertificates: List<SubResourceResponse>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayBackendHttpSettingsResponse):
            ApplicationGatewayBackendHttpSettingsResponse =
            ApplicationGatewayBackendHttpSettingsResponse(
                affinityCookieName = javaType.affinityCookieName().map({ args0 -> args0 }).orElse(null),
                authenticationCertificates = javaType.authenticationCertificates().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }),
                connectionDraining = javaType.connectionDraining().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayConnectionDrainingResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                cookieBasedAffinity = javaType.cookieBasedAffinity().map({ args0 -> args0 }).orElse(null),
                etag = javaType.etag(),
                hostName = javaType.hostName().map({ args0 -> args0 }).orElse(null),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                path = javaType.path().map({ args0 -> args0 }).orElse(null),
                pickHostNameFromBackendAddress = javaType.pickHostNameFromBackendAddress().map({ args0 ->
                    args0
                }).orElse(null),
                port = javaType.port().map({ args0 -> args0 }).orElse(null),
                probe = javaType.probe().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                probeEnabled = javaType.probeEnabled().map({ args0 -> args0 }).orElse(null),
                protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
                provisioningState = javaType.provisioningState(),
                requestTimeout = javaType.requestTimeout().map({ args0 -> args0 }).orElse(null),
                trustedRootCertificates = javaType.trustedRootCertificates().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }),
                type = javaType.type(),
            )
    }
}
